﻿using System;
using System.Windows.Forms;
using System.IO;
using System.Drawing;

namespace tune
{
    public partial class Form1 : Form
    {
        double[] cap1 = new double[] {  33, 100, 150, 330, 680, 1000, 1500, 3300 };
        double[] cap2 = new double[] { 100, 100, 220, 330, 680, 1500, 4700, 4700 };
        double[] cap = new double[] { 0, 0, 0, 0, 0, 0, 0, 0 };
        double[] c = new double[256];   // alle möglichen Kapazitäten

        double[] spulen = new double[] { 0.1, 0.2, 0.4, 0.8, 1.6, 3.2, 6.4, 12.8 };
        double[] ind = new double[256];   // alle möglichen Kapazitäten

        tunevalue [] tvarr = new tunevalue[10];     // Tunerwerte für die ganzen Bänder 

        /*
         * tunervalue:
         * Bit 0..7 = C0..7
         * Bit 8..15 = L0..7
         * Bit 16 = V
         * Bit 17 = H
         */
        UInt32 tunervalue = 0;

        double indsel = 0;
        double capsel = 1e99;
        int indidx = 0;
        int capidx = 0;

        int ostype = 0;
        String cwd = " ";   

        public Form1()
        {
            InitializeComponent();
            

            for (int i = 0; i < 10; i++)
                tvarr[i] = new tunevalue();

            // test OS type
            OperatingSystem osversion = System.Environment.OSVersion;
            if (osversion.VersionString.Contains("indow"))
                ostype = 0;
            else
                ostype = 1;

            cwd = Directory.GetCurrentDirectory();

            readConfig();
            openserport();
            calc_components();
            tb_ind_Scroll(null, null);
            tb_cap_Scroll(null, null);
            rb_coutp_CheckedChanged(null, null);
            rb_cinp_CheckedChanged(null, null);
        }

        void openserport()
        {
            serialPort1.PortName = tb_serport.Text;
            try
            {
                serialPort1.Close();
            }
            catch { }
            try
            {
                serialPort1.Open();
                status_info.Text = "serial port " + serialPort1.PortName + " open";
            }
            catch
            {
                status_info.Text = "serial port error";
            }
        }

        void calc_components()
        {
            // berechne die 8 vorhandenen Kondensatorwerte
            for(int i=0; i<8; i++)
            {
                cap[i] = 1 / (1 / cap1[i] + 1 / cap2[i]);
            }

            // berechne alle möglichen Kombinationen
            c[0] = 10e99; // alles Cs abgeschaltet, unendlich
            for (int i = 1; i < 256; i++)
            {
                c[i] = 0;
                if ((i & 0x01) != 0) c[i] += cap[0];
                if ((i & 0x02) != 0) c[i] += cap[1];
                if ((i & 0x04) != 0) c[i] += cap[2];
                if ((i & 0x08) != 0) c[i] += cap[3];
                if ((i & 0x10) != 0) c[i] += cap[4];
                if ((i & 0x20) != 0) c[i] += cap[5];
                if ((i & 0x40) != 0) c[i] += cap[6];
                if ((i & 0x80) != 0) c[i] += cap[7];
            }

            ind[0] = 0;
            for (int i = 1; i < 256; i++)
            {
                ind[i] = 0;
                if ((i & 0x01) != 0) ind[i] += spulen[0];
                if ((i & 0x02) != 0) ind[i] += spulen[1];
                if ((i & 0x04) != 0) ind[i] += spulen[2];
                if ((i & 0x08) != 0) ind[i] += spulen[3];
                if ((i & 0x10) != 0) ind[i] += spulen[4];
                if ((i & 0x20) != 0) ind[i] += spulen[5];
                if ((i & 0x40) != 0) ind[i] += spulen[6];
                if ((i & 0x80) != 0) ind[i] += spulen[7];
            }

            tb_minmax.Text = "C: " + c[1].ToString("#.") + "pF ... " + c[255].ToString("#.") + "pF    L: " + ind[0] + "uH ... " + ind[255].ToString("#.") + "uH";
        }

        private void tb_ind_Scroll(object sender, EventArgs e)
        {
            indsel = ind[tb_ind.Value];
            if (indsel == 0) lb_ind.Text = "0 uH";
            else
               lb_ind.Text = indsel.ToString("#.#") + " uH";

            indidx = tb_ind.Value;

            //for (int i = 0; i < 5; i++)
            {
                sendTuner();
                //Thread.Sleep(100);
            }
        }

        private void tb_cap_Scroll(object sender, EventArgs e)
        {
            capsel = c[tb_cap.Value];
            if (capsel < 100000)
                lb_cap.Text = capsel.ToString("#.#") + " pF";
            else
                lb_cap.Text = " --- ";

            capidx = 256 - tb_cap.Value;

            //for (int i = 0; i < 5; i++)
            {
                sendTuner();
                //Thread.Sleep(100);
            }
        }

        void sendTuner()
        {
            Console.WriteLine("--------------------------------------------------");
            tunervalue = 0;

            for (int i=0; i<8; i++)
            {
                if ((indidx & (1 << i)) != 0)
                {
                    sertx("L" + (i + 1).ToString() + "0");
                }
                else
                {
                    sertx("L" + (i + 1).ToString() + "1");
                    tunervalue |= ((UInt32)1 << (i + 8));
                }
            }

            if (capidx == 256)
            {
                sertx("H0");
                sertx("V0");
            }
            else
            {
                if (rb_coutp.Checked)
                {
                    sertx("H1");
                    tunervalue |= 0x00020000;
                }
                else
                {
                    sertx("V1");
                    tunervalue |= 0x00010000;
                }

                for (int i = 0; i < 8; i++)
                {
                    if ((capidx & (1 << i)) != 0)
                    {
                        sertx("C" + (i + 1).ToString() + "0");
                    }
                    else
                    {
                        sertx("C" + (i + 1).ToString() + "1");
                        tunervalue |= ((UInt32)1 << i);
                    }
                }
            }

            shortTX(tunervalue);
        }

        void sertx(String s)
        {
            
            /*serialPort1.WriteLine(s);
            Console.WriteLine("TX: " + s);*/
            
        }

        void shortTX(UInt32 val)
        {
            Byte[] ba = new Byte[4];
            ba[0] = (Byte)'K';
            ba[1] = (Byte)(val & 0xff);
            ba[2] = (Byte)((val >> 8) & 0xff);
            ba[3] = (Byte)((val >> 16) & 0xff);

            try
            {
                serialPort1.Write(ba, 0, 4);
            }
            catch { }
            Console.WriteLine("K" + val.ToString("X4"));
        }

        private void rb_coutp_CheckedChanged(object sender, EventArgs e)
        {
            if (rb_coutp.Checked)
                //sertx("H1");
                sendTuner();
        }

        private void rb_cinp_CheckedChanged(object sender, EventArgs e)
        {
            if (rb_cinp.Checked)
                //sertx("V1");
                sendTuner();
        }

        int bandindex(int band)
        {
            if (band == 160) return 0;
            if (band == 80) return 1;
            if (band == 60) return 2;
            if (band == 40) return 3;
            if (band == 30) return 4;
            if (band == 20) return 5;
            if (band == 17) return 6;
            if (band == 15) return 7;
            if (band == 12) return 8;
            return 9;
        }

        void save(int band)
        {
            if(MessageBox.Show("SAVE value ?","SAVE value ?",MessageBoxButtons.YesNo,MessageBoxIcon.Question) == DialogResult.No)
                return;

            tvarr[bandindex(band)].L = indidx;
            tvarr[bandindex(band)].C = capidx;
            tvarr[bandindex(band)].Cinp = rb_cinp.Checked;
            tvarr[bandindex(band)].Coutp = rb_coutp.Checked;
            tvarr[bandindex(band)].Lpoti = tb_ind.Value;
            tvarr[bandindex(band)].Cpoti = tb_cap.Value;
            tvarr[bandindex(band)].tunervalue = tunervalue;

            saveConfig();
        }

        void recall(int band)
        {
            indidx = tvarr[bandindex(band)].L;
            capidx = tvarr[bandindex(band)].C;
            rb_cinp.Checked = tvarr[bandindex(band)].Cinp;
            rb_coutp.Checked = tvarr[bandindex(band)].Coutp;
            tb_ind.Value = tvarr[bandindex(band)].Lpoti;
            tb_cap.Value = tvarr[bandindex(band)].Cpoti;
            // tunervalue = tvarr[bandindex(band)].tunervalue; wird hier nicht benötigt

            // Beschriftung der Slider
            if (ind[tb_ind.Value] == 0) lb_ind.Text = "0 uH";
            else
                lb_ind.Text = ind[tb_ind.Value].ToString("#.#") + " uH";

            if (c[tb_cap.Value] < 100000)
                lb_cap.Text = c[tb_cap.Value].ToString("#.#") + " pF";
            else
                lb_cap.Text = " --- ";

            sendTuner();
        }

        private void bt_s160_Click(object sender, EventArgs e)
        {
            save(160);
        }

        private void bt_s80_Click(object sender, EventArgs e)
        {
            save(80);
        }

        private void bt_s60_Click(object sender, EventArgs e)
        {
            save(60);
        }

        private void bt_s40_Click(object sender, EventArgs e)
        {
            save(40);
        }

        private void bt_s30_Click(object sender, EventArgs e)
        {
            save(30);
        }

        private void bt_s20_Click(object sender, EventArgs e)
        {
            save(20);
        }

        private void bt_s17_Click(object sender, EventArgs e)
        {
            save(17);
        }

        private void bt_s15_Click(object sender, EventArgs e)
        {
            save(15);
        }

        private void bt_s12_Click(object sender, EventArgs e)
        {
            save(12);
        }

        private void bt_s10_Click(object sender, EventArgs e)
        {
            save(10);
        }

        private void bt_r160_Click(object sender, EventArgs e)
        {
            recall(160);
        }

        private void bt_r80_Click(object sender, EventArgs e)
        {
            recall(80);
        }

        private void bt_r60_Click(object sender, EventArgs e)
        {
            recall(60);
        }

        private void bt_r40_Click(object sender, EventArgs e)
        {
            recall(40);
        }

        private void bt_r30_Click(object sender, EventArgs e)
        {
            recall(30);
        }

        private void bt_r20_Click(object sender, EventArgs e)
        {
            recall(20);
        }

        private void bt_r17_Click(object sender, EventArgs e)
        {
            recall(17);
        }

        private void bt_r15_Click(object sender, EventArgs e)
        {
            recall(15);
        }

        private void bt_r12_Click(object sender, EventArgs e)
        {
            recall(12);
        }

        private void bt_r10_Click(object sender, EventArgs e)
        {
            recall(10);
        }

        public String myFilePath(String file)
        {
            if (ostype == 0)
            {
                // Windows
                return Application.UserAppDataPath + "\\" + file;
            }
            else
            {
                return cwd + "/" + file;
            }
        }


        private void saveConfig()
        {
            StreamWriter sw = null;
            try
            {
                Console.WriteLine("write: " + myFilePath("tune.cfg"));
                using (sw = new StreamWriter(myFilePath("tune.cfg")))
                {
                    sw.WriteLine(tb_serport.Text);
                    for (int i = 0; i < 10; i++)
                    {
                        sw.WriteLine(tvarr[i].C.ToString());
                        sw.WriteLine(tvarr[i].L.ToString());
                        sw.WriteLine(tvarr[i].Cpoti.ToString());
                        sw.WriteLine(tvarr[i].Lpoti.ToString());
                        sw.WriteLine(tvarr[i].Cinp ? "1" : "0");
                        sw.WriteLine(tvarr[i].Coutp ? "1" : "0");
                    }
                }

                using (sw = new StreamWriter(myFilePath("tunervalues.num")))
                {
                    for (int i = 0; i < 10; i++)
                    {
                        sw.WriteLine(tvarr[i].tunervalue.ToString());
                    }
                }
            }
            catch(Exception e)
            {
                Console.WriteLine(myFilePath("tune.cfg") + " kann nicht geschrieben werden: " + e.ToString());
            }

            readConfig();
        }

        private void readConfig()
        {
            StreamReader sr = null;
            try
            {
                Console.WriteLine("read: " + myFilePath("tune.cfg"));
                using (sr = new StreamReader(myFilePath("tune.cfg")))
                {
                    tb_serport.Text = ReadString(sr);
                    for (int i = 0; i < 10; i++)
                    {
                        tvarr[i].C = Convert.ToInt32(ReadString(sr));
                        tvarr[i].L = Convert.ToInt32(ReadString(sr));
                        tvarr[i].Cpoti = Convert.ToInt32(ReadString(sr));
                        tvarr[i].Lpoti = Convert.ToInt32(ReadString(sr));
                        String sv = ReadString(sr);
                        tvarr[i].Cinp = (sv == "1" ? true : false);
                        sv = ReadString(sr);
                        tvarr[i].Coutp = (sv == "1" ? true : false);
                    }
                }
            }
            catch
            {
                Console.WriteLine(myFilePath("tune.cfg") +" kann nicht gelesen werden");
            }

            // lese noch die Tunervalues um die Recallbuttons einzufärben wenn was drin steht
            StreamReader srv = null;
            try
            {
                Console.WriteLine("read: " + myFilePath("tunervalues.num"));
                using (srv = new StreamReader(myFilePath("tunervalues.num")))
                {
                    for (int i = 0; i < 10; i++)
                    {
                        uint v = Convert.ToUInt32(ReadString(srv));
                        tvarr[i].tunervalue = v;
                        Console.WriteLine(i.ToString() + " " + v.ToString());
                        if (v != 0)
                        {
                            switch(i)
                            {
                                case 0: bt_r160.BackColor = Color.Green; break;
                                case 1: bt_r80.BackColor = Color.Green; break;
                                case 2: bt_r60.BackColor = Color.Green; break;
                                case 3: bt_r40.BackColor = Color.Green; break;
                                case 4: bt_r30.BackColor = Color.Green; break;
                                case 5: bt_r20.BackColor = Color.Green; break;
                                case 6: bt_r17.BackColor = Color.Green; break;
                                case 7: bt_r15.BackColor = Color.Green; break;
                                case 8: bt_r12.BackColor = Color.Green; break;
                                case 9: bt_r10.BackColor = Color.Green; break;
                            }
                        }
                    }
                }
            }
            catch
            {
            }
        }

        private String ReadString(StreamReader sr)
        {
            String s = sr.ReadLine();
            if (s != null)
            {
                return s;
            }
            return " ";
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            saveConfig();
        }
    }

    class tunevalue
    {
        public int L;
        public int C;
        public int Lpoti;
        public int Cpoti;
        public bool Cinp;
        public bool Coutp;
        public UInt32 tunervalue;
    }
}
