/*
  Web Server for Remote Switch Box

  DJ0ABR 10.2021

*/

#include <SPI.h>
#include <Ethernet2.h>

// ================ Text-Strings (in flash) containing the web page =======================

const char style[] PROGMEM = R"=====(
<style>
.diagselbutton {
    background: #9C9C9C;
    background-image: -webkit-linear-gradient(top, #9C9C9C, #8F8F8F);
    background-image: -moz-linear-gradient(top, #9C9C9C, #8F8F8F);
    background-image: -ms-linear-gradient(top, #9C9C9C, #8F8F8F);
    background-image: -o-linear-gradient(top, #9C9C9C, #8F8F8F);
    background-image: linear-gradient(to bottom, #9C9C9C, #8F8F8F);
    -webkit-border-radius: 20px;
    -moz-border-radius: 20px;
    border-radius: 20px;
    color: #FFFFFF;
    font-family: Open Sans;
    font-size: 20px;
    font-weight: 400;
    padding: 4px;
    box-shadow: 12px 14px 16px 0px #575757;
    -webkit-box-shadow: 12px 14px 16px 0px #575757;
    -moz-box-shadow: 12px 14px 16px 0px #575757;
    text-shadow: 8px 1px 11px #000000;
    border: solid #000000 1px;
    text-decoration: none;
    display: inline-block;
    cursor: pointer;
    margin-left: 6px;
    width: 140px;
    display: inline-block;
    text-align: center;
}

.diagselbutton:hover {
   background: #1E62D0;
   background-image: -webkit-linear-gradient(top, #1E62D0, #3D94F6);
   background-image: -moz-linear-gradient(top, #1E62D0, #3D94F6);
   background-image: -ms-linear-gradient(top, #1E62D0, #3D94F6);
   background-image: -o-linear-gradient(top, #1E62D0, #3D94F6);
   background-image: linear-gradient(to bottom, #1E62D0, #3D94F6);
   text-decoration: none;
}

.diagselbutton:active {
   transform: translateY(4px);
}

.label {
color:lightgray;
margin-left: 20px;
margin-top:30px;
font-size: 30px;
font-weight: 1000;
}
</style>
)=====";

const char script[] PROGMEM = R"=====(
var url = location.href;
window.onload = onstart;
//var A="0",B="0",C="0",D="0";
            
function onstart() 
{
  setTimeout(GetSwitchState, 1000);
}

function GetSwitchState()
{
  var req=new XMLHttpRequest();
  req.onreadystatechange=function()
  {
    if(this.readyState==4)
    {
      if(this.status==200)
      {
        if(this.responseText!=null)
        {
          a = this.responseText[0];
          b = this.responseText[1];
          c = this.responseText[2];
          d = this.responseText[3];
          color();
          setTimeout(GetSwitchState, 1000);
        }
      }
    }
  }
  var reqstr="ajax_switch." +A+B+C+D+ "&ck"+Math.random()*1000000;
  req.open("GET",reqstr,true);
  req.send(null);

  A=B=C=D="0";
}

function clk(sw)
{
  if(sw == 1) A="1";
  if(sw == 2) B="1";
  if(sw == 3) C="1";
  if(sw == 4) D="1";
}

function color()
{
  v = document.getElementById("a230");
  if(a == "0")
  {
    v.style.color = "lightgray";    
    v.innerHTML = "off";
  }
  else
  {
    v.style.color = "green";
    v.innerHTML = "POWER ON";
  }

  v = document.getElementById("b230");
  if(b == "0")
  {
    v.style.color = "lightgray";    
    v.innerHTML = "off";
  }
  else
  {
    v.style.color = "green";
    v.innerHTML = "POWER ON";
  }

  v = document.getElementById("a12");
  if(c == "0")
  {
    v.style.color = "lightgray";    
    v.innerHTML = "off";
  }
  else
  {
    v.style.color = "green";
    v.innerHTML = "POWER ON";
  }

  v = document.getElementById("b12");
  if(d == "0")
  {
    v.style.color = "lightgray";    
    v.innerHTML = "off";
  }
  else
  {
    v.style.color = "green";
    v.innerHTML = "POWER ON";
  }
}
</script>
</head>
)=====";


const char header[] PROGMEM = R"=====(
<!DOCTYPE HTML>
<html lang="de">
<head>
<title>RemoteBox DJ0ABR</title>
)=====";

const char htmlstring[] PROGMEM = R"=====(
<body>
<h1>Remote Switch Box - DJ0ABR</h1>
<button type="button" class="diagselbutton" onclick="clk(1)">230V A</button>
<span id="a230" class="label">*</span><BR><BR><HR>
<button type="button" class="diagselbutton" onclick="clk(2)">230V B</button>
<span id="b230" class="label">*</span><BR><BR><HR>
<button type="button" class="diagselbutton" onclick="clk(3)"> 12V A</button>
<span id="a12" class="label">*</span><BR><BR><HR>
<button type="button" class="diagselbutton" onclick="clk(4)"> 12V B</button>
<span id="b12" class="label">*</span><BR><BR><HR>
</body>
</html>
)=====";


// ======================= Arduino UNO firmware ============================

// Enter a MAC address and IP address for your controller below.
// The IP address will be dependent on your local network:
byte mac[] = {
  0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED
};
IPAddress ip(192, 168, 10, 23);

// Initialize the Ethernet server library
// with the IP address and port you want to use
// (port 80 is default for HTTP):
EthernetServer server(80);

#define RXSIZE 50
char rxstr[RXSIZE];
int rxpos = 0;
char relstat[4];

// Relais
#define D4_N1 4
#define D4_N2 5
#define D4_12A 7
#define D4_12B 6

// LEDs
#define L_N1 0
#define L_N2 1
#define L_12A 2
#define L_12B 3

// Notaus
#define NOTAUS 9

void setup() {
  // Open serial communications and wait for port to open:
  //Serial.begin(9600); // do not use, Port 0/1 is used by LEDs

  for(int i=0; i<4; i++) relstat[i]=0;

  pinMode(D4_N1,OUTPUT);
  pinMode(D4_N2,OUTPUT);
  pinMode(D4_12A,OUTPUT);
  pinMode(D4_12B,OUTPUT);
  pinMode(L_N1,OUTPUT);
  pinMode(L_N2,OUTPUT);
  pinMode(L_12A,OUTPUT);
  pinMode(L_12B,OUTPUT);
  pinMode(NOTAUS,INPUT_PULLUP);
  digitalWrite(D4_N1,0);
  digitalWrite(D4_N2,0);
  digitalWrite(D4_12A,0);
  digitalWrite(D4_12B,0);
  digitalWrite(L_N1,1);
  digitalWrite(L_N2,1);
  digitalWrite(L_12A,1);
  digitalWrite(L_12B,1);
 
  // start the Ethernet connection and the server:
  Ethernet.begin(mac, ip);
  server.begin();
}

// send HTML string from flash
void printhtml(EthernetClient client, const char *t PROGMEM)
{
  for (int k = 0; k < strlen_P(t); k++) 
  {
    char myChar = pgm_read_byte_near(t + k);
    if(myChar == '^') myChar = '\n';
    client.print(myChar);
  }
}

void switchRelais()
{
  if(!relstat[0])
  {
    // switch off Relais A230
    digitalWrite(D4_N1,0);
    digitalWrite(L_N1,1);
  }
  else
  {
    // switch on Relais A230
    digitalWrite(D4_N1,1);
    digitalWrite(L_N1,0);
  }

  if(!relstat[1])
  {
    // switch off Relais B230
    digitalWrite(D4_N2,0);
    digitalWrite(L_N2,1);
  }
  else
  {
    // switch on Relais B230
    digitalWrite(D4_N2,1);
    digitalWrite(L_N2,0);
  }

  if(!relstat[2])
  {
    // switch off Relais A12
    digitalWrite(D4_12A,1);
    digitalWrite(L_12A,1);
  }
  else
  {
    // switch on Relais A12
    digitalWrite(D4_12A,0);
    digitalWrite(L_12A,0);
  }

  if(!relstat[3])
  {
    // switch off Relais B12
    digitalWrite(D4_12B,1);
    digitalWrite(L_12B,1);
  }
  else
  {
    // switch on Relais B12
    digitalWrite(D4_12B,0);
    digitalWrite(L_12B,0);
  }
}

void loop() 
{
 
  // NOTAUS
  if(digitalRead(NOTAUS) == 0)
  {
    int to = 20;
    int notaus = 1;
    while(to--)
    {
      if(digitalRead(NOTAUS) != 0) 
      {
        notaus = 0;
        break;
      }
      delay(100);
    }

    if(notaus)
    {
      for(int i=0; i<4; i++) relstat[i]=0;
      switchRelais();
    }
  }
  
  // listen for incoming clients
  EthernetClient client = server.available();
  if (client) {
    //Serial.println("==========================================================");
    //Serial.println("new client");
    // an http request ends with a blank line
    boolean currentLineIsBlank = true;
    while (client.connected()) {
      if (client.available()) {
        char c = client.read();
        if(rxpos < (RXSIZE-1))
        {
          rxstr[rxpos] = c;
          rxstr[rxpos+1] = 0;
          rxpos++;
        }
        
        //Serial.write(c);
        // if you've gotten to the end of the line (received a newline
        // character) and the line is blank, the http request has ended,
        // so you can send a reply
        if (c == '\n' && currentLineIsBlank) 
        {
          rxpos=0;

          //Serial.println("request received, now send response");
          client.println("HTTP/1.1 200 OK");
          client.println("Content-Type: text/html; charset=UTF-8");
          client.println("Connection: keep-alive");  // the connection will be closed after completion of the response
          client.println();

          char *hp1 = strstr(rxstr,"ajax_switch.");
          if(hp1 != NULL)
          {
            // read button state
            hp1+=12;

            // toggle marked button
            if(hp1[0] == '1') relstat[0] = (relstat[0]==1)?0:1;
            if(hp1[1] == '1') relstat[1] = (relstat[1]==1)?0:1;
            if(hp1[2] == '1') relstat[2] = (relstat[2]==1)?0:1;
            if(hp1[3] == '1') relstat[3] = (relstat[3]==1)?0:1;
            
            switchRelais();
              
            // return switch state to the browser
            char stat[5];
            stat[0] = (relstat[0])?'1':'0';
            stat[1] = (relstat[1])?'1':'0';
            stat[2] = (relstat[2])?'1':'0';
            stat[3] = (relstat[3])?'1':'0';
            stat[4] = 0;
            client.print(stat);
          }
          else
          {
            printhtml(client, header);
            printhtml(client, style);
            // Initialer Stand nach dem Laden der Seite, danach gehts mit Ajax weiter
            client.println("<script type=\"text/javascript\">");
            char vars[] = "var A=\"0\",B=\"0\",C=\"0\",D=\"0\"";
            client.println(vars);
            printhtml(client, script);
            printhtml(client, htmlstring);
          }
          break;
        }
        if (c == '\n') {
          currentLineIsBlank = true;
        }
        else if (c != '\r') {
          currentLineIsBlank = false;
        }
      }
    }
    delay(1);
    client.stop();
  }
}
