/*
 * Display für CNC Handgerät
 * =========================
 * 
 * ESP8266MOD mit ILI9341 Display
 * 
 * Arduino Einstellungen:
 * Boardverwalter URL: http://arduino.esp8266.com/stable/package_esp8266com_index.json
 * Board: NodeMCU 1.0 (ESP-12E Module)
 */

#include "Adafruit_GFX.h"       // include Adafruit graphics library
#include "Adafruit_ILI9341.h"   // include Adafruit ILI9341 TFT library
#include "ESP8266WiFi.h"
#include <WiFiUdp.h>
#include "Fonts/FreeSans9pt7b.h"
#include "Fonts/FreeSans12pt7b.h"
#include "Fonts/FreeSans18pt7b.h"
#include "display.h"

// Icons
#include "icons.h"

// ===== Netzwerkeinstellungen ======
//char* ssid     = "HT2";
char* ssid     = "xxxxxxx";
char* password = "xxxxxxx";
WiFiUDP Udp;
unsigned int localUdpPort = 13579;
char incomingPacket[256];
// ==================================

// ========== TFT Display ===========
#define TFT_CS    D2
#define TFT_RST   D3
#define TFT_DC    D4
// initialize ILI9341 TFT library with hardware SPI module
// SCK (CLK) ---> NodeMCU pin D5 (GPIO14)
// MOSI(DIN) ---> NodeMCU pin D7 (GPIO13)
Adafruit_ILI9341 tft = Adafruit_ILI9341(TFT_CS, TFT_DC, TFT_RST);
int TEXTCOL = ILI9341_WHITE;
// =================================

void setup() 
{
  Serial.begin(115200);
  Serial.println("CNC Remote Display"); 
 
  tft.begin();
  tft.setRotation(3);
  setMyFont(3);
  
  tft.fillScreen(ILI9341_BLACK);
  printText(60,25,"CNC ek_mill");
  tft.fillRect(0, 30, 319, 3, ILI9341_WHITE);
  printText(0,80,"WiFi:connecting..");
  
  Serial.print("Connecting to ");

  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) 
  {
      delay(500);
      Serial.print(".");
  }

  Serial.println("WiFi connected");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());

  printText(0,115,"WiFi:connected to");
  printText(0,150,ssid);
  printText(0,185,WiFi.localIP().toString().c_str());
  
  Udp.begin(localUdpPort);

  delay(2000);
  tft.fillScreen(ILI9341_BLACK);
  setMyFont(2);
  printText(10,20,"CNC ek_mill");
  setMyFont(1);
  printText(175,20,WiFi.localIP().toString().c_str());
  tft.fillRect(0, 28, 319, 3, ILI9341_WHITE);

  // Beschriftung der Zeilen
  setMyFont(1);
  printText(80,46,"ABS");
  printText(230,46,"G54");
  int ytop = 71;
  int yspc = 26;
  setMyFont(2);
  printText(0,ytop,elemname[1]);
  printText(0,ytop + yspc*1,elemname[2]);
  printText(0,ytop + yspc*2,elemname[3]);
  printText(0,ytop + yspc*3,elemname[4]);

  setMyFont(1);
  printText(173,188,"Speed:");

  int ly=50;
  tft.drawLine(0,ly,319,ly,ILI9341_WHITE);
  ly+=26;
  tft.drawLine(0,ly,319,ly,ILI9341_WHITE);
  ly+=26;
  tft.drawLine(0,ly,319,ly,ILI9341_WHITE);
  ly+=26;
  tft.drawLine(0,ly,319,ly,ILI9341_WHITE);
  ly+=26;
  tft.fillRect(0, ly, 319, 3, ILI9341_WHITE);
  
  int lx = 18;
  tft.drawLine(lx,30,lx,ly,ILI9341_WHITE);
  lx = 170;
  tft.drawLine(lx,30,lx,ly,ILI9341_WHITE);

  // stelle auf Default Font, da nur damit der Hintergrund gelöscht wird
  tft.setFont(NULL);
  tft.setTextSize(1);
  printText(298,ytop-8,"mm");
  printText(298,ytop + yspc*1-8,"mm");
  printText(298,ytop + yspc*2-8,"mm");
  printText(298,ytop + yspc*3-8,"mm");
  printText(148,ytop-8,"mm");
  printText(148,ytop + yspc*1-8,"mm");
  printText(148,ytop + yspc*2-8,"mm");
  printText(148,ytop + yspc*3-8,"mm");
  printText(284,182,"mm/min");
  tft.setTextSize(2);
}

void setMyFont(int fontno)
{
  if(fontno == 1) tft.setFont(&FreeSans9pt7b);
  if(fontno == 2) tft.setFont(&FreeSans12pt7b);
  if(fontno == 3) tft.setFont(&FreeSans18pt7b);
  tft.setTextSize(1);
}

void printText(int x, int y, const char *text) 
{
  tft.setCursor(x, y);
  tft.setTextColor(TEXTCOL, ILI9341_BLACK);    
  tft.println(text);
}

void drawIcon(int iconnr)
{
  unsigned short *p = NULL;
  int y = 0;
  int x = 0;
  
  switch(iconnr)
  {
    case Icon_ON: p = image_data_machineON; 
            y = icon_Y1;
            x = icon_X;
            break;
    case Icon_OFF: p = image_data_machineOFF; 
            y = icon_Y1;
            x = icon_X;
            break;
    case Icon_spray: p = image_data_spray; 
            y = icon_Y2;
            x = icon_X + icon_Xincr * 5;
            break;
    case Icon_spray_inact: p = image_data_spray_inact; 
            y = icon_Y2;
            x = icon_X + icon_Xincr * 5;
            break;
    case Icon_running: p = image_data_running; 
            y = icon_Y1;
            x = icon_X + icon_Xincr * 2;
            break;
    case Icon_pause: p = image_data_pause; 
            y = icon_Y1;
            x = icon_X + icon_Xincr * 2;
            break;
    case Icon_stop: p = image_data_stop; 
            y = icon_Y1;
            x = icon_X + icon_Xincr * 2;
            break;
    case Icon_manual: p = image_data_manual; 
            y = icon_Y1;
            x = icon_X + icon_Xincr * 1;
            break;
    case Icon_mdi: p = image_data_mdi; 
            y = icon_Y1;
            x = icon_X + icon_Xincr * 1;
            break;
    case Icon_auto: p = image_data_auto; 
            y = icon_Y1;
            x = icon_X + icon_Xincr * 1;
            break;
    case Icon_xref: p = image_data_xref; 
            y = icon_Y2;
            x = icon_X;
            break;
    case Icon_xref_inact: p = image_data_xref_inact; 
            y = icon_Y2;
            x = icon_X;
            break;
    case Icon_yref: p = image_data_yref; 
            y = icon_Y2;
            x = icon_X + icon_Xincr * 1;
            break;
    case Icon_yref_inact: p = image_data_yref_inact; 
            y = icon_Y2;
            x = icon_X + icon_Xincr * 1;
            break;
    case Icon_zref: p = image_data_zref; 
            y = icon_Y2;
            x = icon_X + icon_Xincr * 2;
            break;
    case Icon_zref_inact: p = image_data_zref_inact; 
            y = icon_Y2;
            x = icon_X + icon_Xincr * 2;
            break;
    case Icon_probe: p = image_data_probe; 
            y = icon_Y2;
            x = icon_X + icon_Xincr * 3;
            break;
    case Icon_probe_inact: p = image_data_probe_inact; 
            y = icon_Y2;
            x = icon_X + icon_Xincr * 3;
            break;
    case Icon_limit: p = image_data_limit; 
            y = icon_Y2;
            x = icon_X + icon_Xincr * 4;
            break;
    case Icon_limit_inact: p = image_data_limit_inact; 
            y = icon_Y2;
            x = icon_X + icon_Xincr * 4;
            break;
  }

  tft.drawRGBBitmap(x, y, p,32,32);
}

int act_spray = 0, act_play = 0, act_pause = 0, act_onoff = 0, act_mode = 0;
int act_xref = 0, act_yref = 0, act_zref = 0, act_probe = 0, act_limit = 0;

void loop()
{
  int packetSize = Udp.parsePacket();
  if (packetSize)
  {
    int len = Udp.read(incomingPacket, 255);

    /*incomingPacket[len]=0;
    Serial.print("RXed len: ");
    Serial.print(len);
    Serial.print(": ");
    Serial.print(Udp.remoteIP());
    Serial.print(": ");
    Serial.println(incomingPacket);*/

    rxfunc(incomingPacket, len);
    
    int xa = 35;
    int xg = 185;
    int y = 56;
    int ls = 26;
    
    TEXTCOL = ILI9341_YELLOW;

    printText(xa,y+ls*0,rxelem[EL_XABS]);
    printText(xa,y+ls*1,rxelem[EL_YABS]);
    printText(xa,y+ls*2,rxelem[EL_ZABS]);
    printText(xa,y+ls*3,rxelem[EL_AABS]);
    
    TEXTCOL = ILI9341_GREEN;
    
    printText(xg,y+ls*0,rxelem[EL_XG54]);
    printText(xg,y+ls*1,rxelem[EL_YG54]);
    printText(xg,y+ls*2,rxelem[EL_ZG54]);
    printText(xg,y+ls*3,rxelem[EL_AG54]);

    TEXTCOL = ILI9341_WHITE;

    float speed = atof(rxelem[EL_SPEED]) * 60;
    if(speed > 9999.0) speed = 9999.0;
    char s[20];
    sprintf(s,"%4.0f",speed);
    printText(234,176,s);
    
    if(rxelem[EL_KSM][0]    == 'T') act_spray = 1; else act_spray = 0;
    if(rxelem[EL_PAUSE][0]  == 'T') act_pause = 1; else act_pause = 0;
    if(rxelem[EL_RUNNING][0]== 'T') act_play = 1; else act_play = 0;
    if(rxelem[EL_ONOFF][0]  == 'T') act_onoff = 1; else act_onoff = 0;
    if(rxelem[EL_AUTO][0]   == 'T') act_mode = 2;
    if(rxelem[EL_MDI][0]    == 'T') act_mode = 1;
    if(rxelem[EL_MANUELL][0]== 'T') act_mode = 0;
    if(rxelem[EL_PROBE][0]    == 'T') act_probe = 1; else act_probe = 0;
    if(rxelem[EL_LIMIT][0]    == 'T') act_limit = 1; else act_limit = 0;
    if(rxelem[EL_XREF][0]    == 'T') act_xref = 1; else act_xref = 0;
    if(rxelem[EL_YREF][0]    == 'T') act_yref = 1; else act_yref = 0;
    if(rxelem[EL_ZREF][0]    == 'T') act_zref = 1; else act_zref = 0;
  }

  static int old_spray = -1;  
  static int old_play = -1;  
  static int old_pause = -1;  
  static int old_onoff = -1;  
  static int old_mode = -1;  
  static int old_xref = -1;
  static int old_yref = -1;
  static int old_zref = -1;
  static int old_probe = -1;
  static int old_limit = -1;

  // Maschine on/off
  if(act_onoff != old_onoff)
  {
    Serial.println(act_onoff?"on":"off");
    if(act_onoff) drawIcon(Icon_ON); else drawIcon(Icon_OFF);
    old_onoff = act_onoff;
  }

  // Op Mode
  if(act_mode != old_mode)
  {
    if(act_mode == 0) drawIcon(Icon_manual);
    if(act_mode == 1) drawIcon(Icon_mdi);
    if(act_mode == 2) drawIcon(Icon_auto);
    old_mode = act_mode;
  }

  // Auto Mode State
  if(act_play != old_play || act_pause != old_pause)
  {
    if(act_play) drawIcon(Icon_running);
    else if(act_pause) drawIcon(Icon_pause);
    else drawIcon(Icon_stop);
    old_play = act_play;
    old_pause = act_pause;
  }

  // KSM
  if(act_spray != old_spray)
  {
    if(act_spray) drawIcon(Icon_spray); else drawIcon(Icon_spray_inact);
    old_spray = act_spray;
  }

  // Referenzschalter
  if(act_xref != old_xref)
  {
    if(act_xref) drawIcon(Icon_xref); else drawIcon(Icon_xref_inact);
    old_xref = act_xref;
  }
  if(act_yref != old_yref)
  {
    if(act_yref) drawIcon(Icon_yref); else drawIcon(Icon_yref_inact);
    old_yref = act_yref;
  }
  if(act_zref != old_zref)
  {
    if(act_zref) drawIcon(Icon_zref); else drawIcon(Icon_zref_inact);
    old_zref = act_zref;
  }

  // Probe und Limit Schalter
  if(act_probe != old_probe)
  {
    if(act_probe) drawIcon(Icon_probe); else drawIcon(Icon_probe_inact);
    old_probe = act_probe;
  }
  if(act_limit != old_limit)
  {
    if(act_limit) drawIcon(Icon_limit); else drawIcon(Icon_limit_inact);
    old_limit = act_limit;
  }
}
