// 
//  Font data for Verdana 18pt
// 

#include <main.h>

// Character bitmaps for Verdana 18pt
const uint8_t verdana_18ptBitmaps[] =
{
	// @0 ' ' (2 pixels wide)
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   

	// @24 '!' (2 pixels wide)
	0x00, //   
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0x00, //   
	0x00, //   
	0x00, //   
	0xC0, // ##
	0xC0, // ##
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   

	// @48 '"' (7 pixels wide)
	0xC6, // ##   ##
	0xC6, // ##   ##
	0xC6, // ##   ##
	0xC6, // ##   ##
	0xC6, // ##   ##
	0xC6, // ##   ##
	0xC6, // ##   ##
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        

	// @72 '#' (15 pixels wide)
	0x00, 0x00, //                
	0x02, 0x08, //       #     #  
	0x02, 0x08, //       #     #  
	0x04, 0x10, //      #     #   
	0x04, 0x10, //      #     #   
	0x04, 0x10, //      #     #   
	0x7F, 0xFE, //  ##############
	0x04, 0x10, //      #     #   
	0x08, 0x20, //     #     #    
	0x08, 0x20, //     #     #    
	0x08, 0x20, //     #     #    
	0x08, 0x20, //     #     #    
	0xFF, 0xFC, // ############## 
	0x10, 0x40, //    #     #     
	0x10, 0x40, //    #     #     
	0x10, 0x40, //    #     #     
	0x10, 0x40, //    #     #     
	0x20, 0x80, //   #     #      
	0x20, 0x80, //   #     #      
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                

	// @120 '$' (11 pixels wide)
	0x00, 0x00, //            
	0x04, 0x00, //      #     
	0x04, 0x00, //      #     
	0x04, 0x00, //      #     
	0x1F, 0x80, //    ######  
	0x7F, 0xC0, //  ######### 
	0xE4, 0x40, // ###  #   # 
	0xC4, 0x00, // ##   #     
	0xC4, 0x00, // ##   #     
	0xE4, 0x00, // ###  #     
	0x7C, 0x00, //  #####     
	0x3F, 0x80, //   #######  
	0x07, 0xC0, //      ##### 
	0x04, 0x60, //      #   ##
	0x04, 0x60, //      #   ##
	0x04, 0x60, //      #   ##
	0xC4, 0xE0, // ##   #  ###
	0xFF, 0xC0, // ########## 
	0x7F, 0x00, //  #######   
	0x04, 0x00, //      #     
	0x04, 0x00, //      #     
	0x04, 0x00, //      #     
	0x04, 0x00, //      #     
	0x00, 0x00, //            

	// @168 '%' (22 pixels wide)
	0x00, 0x00, 0x00, //                       
	0x3E, 0x03, 0x00, //   #####       ##      
	0x7F, 0x02, 0x00, //  #######      #       
	0xE3, 0x86, 0x00, // ###   ###    ##       
	0xC1, 0x84, 0x00, // ##     ##    #        
	0xC1, 0x8C, 0x00, // ##     ##   ##        
	0xC1, 0x88, 0x00, // ##     ##   #         
	0xC1, 0x98, 0x00, // ##     ##  ##         
	0xE3, 0x98, 0x00, // ###   ###  ##         
	0x7F, 0x31, 0xF0, //  #######  ##   #####  
	0x3E, 0x33, 0xF8, //   #####   ##  ####### 
	0x00, 0x67, 0x1C, //          ##  ###   ###
	0x00, 0x66, 0x0C, //          ##  ##     ##
	0x00, 0x46, 0x0C, //          #   ##     ##
	0x00, 0xC6, 0x0C, //         ##   ##     ##
	0x00, 0x86, 0x0C, //         #    ##     ##
	0x01, 0x87, 0x1C, //        ##    ###   ###
	0x01, 0x03, 0xF8, //        #      ####### 
	0x03, 0x01, 0xF0, //       ##       #####  
	0x00, 0x00, 0x00, //                       
	0x00, 0x00, 0x00, //                       
	0x00, 0x00, 0x00, //                       
	0x00, 0x00, 0x00, //                       
	0x00, 0x00, 0x00, //                       

	// @240 '&' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x1F, 0x00, 0x00, //    #####         
	0x3F, 0x80, 0x00, //   #######        
	0x71, 0xC0, 0x00, //  ###   ###       
	0x60, 0xC0, 0x00, //  ##     ##       
	0x60, 0xC0, 0x00, //  ##     ##       
	0x60, 0xC0, 0x00, //  ##     ##       
	0x39, 0x80, 0x00, //   ###  ##        
	0x1F, 0x0C, 0x00, //    #####    ##   
	0x3E, 0x0C, 0x00, //   #####     ##   
	0x63, 0x8C, 0x00, //  ##   ###   ##   
	0x41, 0xCC, 0x00, //  #     ###  ##   
	0xC0, 0xE8, 0x00, // ##      ### #    
	0xC0, 0x78, 0x00, // ##       ####    
	0xC0, 0x38, 0x00, // ##        ###    
	0xE0, 0x3C, 0x00, // ###       ####   
	0x70, 0x6E, 0x00, //  ###     ## ###  
	0x3F, 0xC7, 0x00, //   ########   ### 
	0x1F, 0x03, 0x80, //    #####      ###
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @312 ''' (2 pixels wide)
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   

	// @336 '(' (7 pixels wide)
	0x0E, //     ###
	0x1C, //    ### 
	0x18, //    ##  
	0x30, //   ##   
	0x30, //   ##   
	0x60, //  ##    
	0x60, //  ##    
	0xE0, // ###    
	0xC0, // ##     
	0xC0, // ##     
	0xC0, // ##     
	0xC0, // ##     
	0xC0, // ##     
	0xC0, // ##     
	0xC0, // ##     
	0xC0, // ##     
	0xE0, // ###    
	0x60, //  ##    
	0x60, //  ##    
	0x30, //   ##   
	0x30, //   ##   
	0x18, //    ##  
	0x1C, //    ### 
	0x0E, //     ###

	// @360 ')' (7 pixels wide)
	0xE0, // ###    
	0x70, //  ###   
	0x30, //   ##   
	0x18, //    ##  
	0x18, //    ##  
	0x0C, //     ## 
	0x0C, //     ## 
	0x0E, //     ###
	0x06, //      ##
	0x06, //      ##
	0x06, //      ##
	0x06, //      ##
	0x06, //      ##
	0x06, //      ##
	0x06, //      ##
	0x06, //      ##
	0x0E, //     ###
	0x0C, //     ## 
	0x0C, //     ## 
	0x18, //    ##  
	0x18, //    ##  
	0x30, //   ##   
	0x70, //  ###   
	0xE0, // ###    

	// @384 '*' (12 pixels wide)
	0x06, 0x00, //      ##     
	0x06, 0x00, //      ##     
	0xC6, 0x30, // ##   ##   ##
	0x76, 0xE0, //  ### ## ### 
	0x1F, 0x80, //    ######   
	0x06, 0x00, //      ##     
	0x1F, 0x80, //    ######   
	0x76, 0xE0, //  ### ## ### 
	0xC6, 0x30, // ##   ##   ##
	0x06, 0x00, //      ##     
	0x06, 0x00, //      ##     
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             

	// @432 '+' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0xFF, 0xFC, // ##############
	0xFF, 0xFC, // ##############
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @480 ',' (5 pixels wide)
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x38, //   ###
	0x30, //   ## 
	0x70, //  ### 
	0x70, //  ### 
	0x60, //  ##  
	0x60, //  ##  
	0xC0, // ##   
	0xC0, // ##   

	// @504 '-' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0xFE, // #######
	0xFE, // #######
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        

	// @528 '.' (3 pixels wide)
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0xE0, // ###
	0xE0, // ###
	0xE0, // ###
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    

	// @552 '/' (10 pixels wide)
	0x00, 0xC0, //         ##
	0x01, 0x80, //        ## 
	0x01, 0x80, //        ## 
	0x01, 0x80, //        ## 
	0x03, 0x00, //       ##  
	0x03, 0x00, //       ##  
	0x03, 0x00, //       ##  
	0x06, 0x00, //      ##   
	0x06, 0x00, //      ##   
	0x06, 0x00, //      ##   
	0x0C, 0x00, //     ##    
	0x0C, 0x00, //     ##    
	0x0C, 0x00, //     ##    
	0x18, 0x00, //    ##     
	0x18, 0x00, //    ##     
	0x18, 0x00, //    ##     
	0x30, 0x00, //   ##      
	0x30, 0x00, //   ##      
	0x30, 0x00, //   ##      
	0x60, 0x00, //  ##       
	0x60, 0x00, //  ##       
	0x60, 0x00, //  ##       
	0xC0, 0x00, // ##        
	0x00, 0x00, //           

	// @600 '0' (11 pixels wide)
	0x00, 0x00, //            
	0x1F, 0x00, //    #####   
	0x3F, 0x80, //   #######  
	0x71, 0xC0, //  ###   ### 
	0x60, 0xC0, //  ##     ## 
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0x60, 0xC0, //  ##     ## 
	0x71, 0xC0, //  ###   ### 
	0x3F, 0x80, //   #######  
	0x1F, 0x00, //    #####   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @648 '1' (10 pixels wide)
	0x00, 0x00, //           
	0x0C, 0x00, //     ##    
	0x1C, 0x00, //    ###    
	0xFC, 0x00, // ######    
	0xFC, 0x00, // ######    
	0x0C, 0x00, //     ##    
	0x0C, 0x00, //     ##    
	0x0C, 0x00, //     ##    
	0x0C, 0x00, //     ##    
	0x0C, 0x00, //     ##    
	0x0C, 0x00, //     ##    
	0x0C, 0x00, //     ##    
	0x0C, 0x00, //     ##    
	0x0C, 0x00, //     ##    
	0x0C, 0x00, //     ##    
	0x0C, 0x00, //     ##    
	0x0C, 0x00, //     ##    
	0xFF, 0xC0, // ##########
	0xFF, 0xC0, // ##########
	0x00, 0x00, //           
	0x00, 0x00, //           
	0x00, 0x00, //           
	0x00, 0x00, //           
	0x00, 0x00, //           

	// @696 '2' (11 pixels wide)
	0x00, 0x00, //            
	0x3E, 0x00, //   #####    
	0xFF, 0x80, // #########  
	0xC1, 0x80, // ##     ##  
	0x80, 0xC0, // #       ## 
	0x00, 0xC0, //         ## 
	0x00, 0xC0, //         ## 
	0x00, 0xC0, //         ## 
	0x01, 0xC0, //        ### 
	0x01, 0x80, //        ##  
	0x03, 0x00, //       ##   
	0x07, 0x00, //      ###   
	0x0E, 0x00, //     ###    
	0x1C, 0x00, //    ###     
	0x38, 0x00, //   ###      
	0x70, 0x00, //  ###       
	0xE0, 0x00, // ###        
	0xFF, 0xE0, // ###########
	0xFF, 0xE0, // ###########
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @744 '3' (11 pixels wide)
	0x00, 0x00, //            
	0x3F, 0x00, //   ######   
	0xFF, 0xC0, // ########## 
	0xE0, 0xE0, // ###     ###
	0x80, 0x60, // #        ##
	0x00, 0x60, //          ##
	0x00, 0x60, //          ##
	0x00, 0xC0, //         ## 
	0x0F, 0x00, //     ####   
	0x0F, 0x80, //     #####  
	0x00, 0xC0, //         ## 
	0x00, 0x60, //          ##
	0x00, 0x60, //          ##
	0x00, 0x60, //          ##
	0x00, 0x60, //          ##
	0x80, 0xE0, // #       ###
	0xE1, 0xC0, // ###    ### 
	0xFF, 0x80, // #########  
	0x3F, 0x00, //   ######   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @792 '4' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x60, //          ##   
	0x00, 0xE0, //         ###   
	0x01, 0xE0, //        ####   
	0x03, 0xE0, //       #####   
	0x07, 0x60, //      ### ##   
	0x0E, 0x60, //     ###  ##   
	0x1C, 0x60, //    ###   ##   
	0x38, 0x60, //   ###    ##   
	0x30, 0x60, //   ##     ##   
	0x60, 0x60, //  ##      ##   
	0xC0, 0x60, // ##       ##   
	0xFF, 0xFC, // ##############
	0xFF, 0xFC, // ##############
	0x00, 0x60, //          ##   
	0x00, 0x60, //          ##   
	0x00, 0x60, //          ##   
	0x00, 0x60, //          ##   
	0x00, 0x60, //          ##   
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @840 '5' (11 pixels wide)
	0x00, 0x00, //            
	0x7F, 0xE0, //  ##########
	0x7F, 0xE0, //  ##########
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x7F, 0x00, //  #######   
	0x7F, 0xC0, //  ######### 
	0x01, 0xC0, //        ### 
	0x00, 0x60, //          ##
	0x00, 0x60, //          ##
	0x00, 0x60, //          ##
	0x00, 0x60, //          ##
	0x00, 0xE0, //         ###
	0xC1, 0xC0, // ##     ### 
	0xFF, 0x80, // #########  
	0x7F, 0x00, //  #######   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @888 '6' (11 pixels wide)
	0x00, 0x00, //            
	0x07, 0x80, //      ####  
	0x1F, 0x80, //    ######  
	0x38, 0x00, //   ###      
	0x70, 0x00, //  ###       
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0xC0, 0x00, // ##         
	0xDF, 0x00, // ## #####   
	0xFF, 0xC0, // ########## 
	0xE0, 0xC0, // ###     ## 
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0x60, 0x60, //  ##      ##
	0x70, 0xC0, //  ###    ## 
	0x3F, 0x80, //   #######  
	0x1F, 0x00, //    #####   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @936 '7' (12 pixels wide)
	0x00, 0x00, //             
	0xFF, 0xF0, // ############
	0xFF, 0xF0, // ############
	0x00, 0x30, //           ##
	0x00, 0x30, //           ##
	0x00, 0x60, //          ## 
	0x00, 0x60, //          ## 
	0x00, 0xC0, //         ##  
	0x00, 0xC0, //         ##  
	0x01, 0x80, //        ##   
	0x03, 0x80, //       ###   
	0x03, 0x00, //       ##    
	0x07, 0x00, //      ###    
	0x06, 0x00, //      ##     
	0x0E, 0x00, //     ###     
	0x0C, 0x00, //     ##      
	0x1C, 0x00, //    ###      
	0x18, 0x00, //    ##       
	0x38, 0x00, //   ###       
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             

	// @984 '8' (11 pixels wide)
	0x00, 0x00, //            
	0x1F, 0x00, //    #####   
	0x7F, 0xC0, //  ######### 
	0x60, 0xE0, //  ##     ###
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xE0, 0xC0, // ###     ## 
	0x79, 0x80, //  ####  ##  
	0x3F, 0x00, //   ######   
	0x63, 0x80, //  ##   ###  
	0x60, 0xC0, //  ##     ## 
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xE0, 0x60, // ###      ##
	0x70, 0xC0, //  ###    ## 
	0x7F, 0x80, //  ########  
	0x1F, 0x00, //    #####   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1032 '9' (11 pixels wide)
	0x00, 0x00, //            
	0x1F, 0x00, //    #####   
	0x3F, 0x80, //   #######  
	0x61, 0xC0, //  ##    ### 
	0xE0, 0xC0, // ###     ## 
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0x60, 0xE0, //  ##     ###
	0x7F, 0xE0, //  ##########
	0x1F, 0x60, //    ##### ##
	0x00, 0x60, //          ##
	0x00, 0xC0, //         ## 
	0x00, 0xC0, //         ## 
	0x01, 0xC0, //        ### 
	0x23, 0x80, //   #   ###  
	0x3F, 0x00, //   ######   
	0x3E, 0x00, //   #####    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1080 ':' (3 pixels wide)
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0xE0, // ###
	0xE0, // ###
	0xE0, // ###
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0xE0, // ###
	0xE0, // ###
	0xE0, // ###
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    
	0x00, //    

	// @1104 ';' (5 pixels wide)
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x70, //  ### 
	0x70, //  ### 
	0x70, //  ### 
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x38, //   ###
	0x30, //   ## 
	0x70, //  ### 
	0x70, //  ### 
	0x60, //  ##  
	0x60, //  ##  
	0xC0, // ##   
	0xC0, // ##   

	// @1128 '<' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x0C, //             ##
	0x00, 0x3C, //           ####
	0x01, 0xF0, //        #####  
	0x07, 0xC0, //      #####    
	0x1F, 0x00, //    #####      
	0x78, 0x00, //  ####         
	0xE0, 0x00, // ###           
	0x78, 0x00, //  ####         
	0x1F, 0x00, //    #####      
	0x07, 0xC0, //      #####    
	0x01, 0xF0, //        #####  
	0x00, 0x3C, //           ####
	0x00, 0x0C, //             ##
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1176 '=' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0xFF, 0xFC, // ##############
	0xFF, 0xFC, // ##############
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0xFF, 0xFC, // ##############
	0xFF, 0xFC, // ##############
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1224 '>' (14 pixels wide)
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0xC0, 0x00, // ##            
	0xF0, 0x00, // ####          
	0x3E, 0x00, //   #####       
	0x0F, 0x80, //     #####     
	0x03, 0xE0, //       #####   
	0x00, 0x78, //          #### 
	0x00, 0x1C, //            ###
	0x00, 0x78, //          #### 
	0x03, 0xE0, //       #####   
	0x0F, 0x80, //     #####     
	0x3E, 0x00, //   #####       
	0xF0, 0x00, // ####          
	0xC0, 0x00, // ##            
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1272 '?' (10 pixels wide)
	0x00, 0x00, //           
	0x7E, 0x00, //  ######   
	0xFF, 0x80, // ######### 
	0x81, 0xC0, // #      ###
	0x00, 0xC0, //         ##
	0x00, 0xC0, //         ##
	0x00, 0xC0, //         ##
	0x01, 0xC0, //        ###
	0x01, 0x80, //        ## 
	0x07, 0x00, //      ###  
	0x1E, 0x00, //    ####   
	0x18, 0x00, //    ##     
	0x18, 0x00, //    ##     
	0x18, 0x00, //    ##     
	0x00, 0x00, //           
	0x00, 0x00, //           
	0x00, 0x00, //           
	0x18, 0x00, //    ##     
	0x18, 0x00, //    ##     
	0x00, 0x00, //           
	0x00, 0x00, //           
	0x00, 0x00, //           
	0x00, 0x00, //           
	0x00, 0x00, //           

	// @1320 '@' (20 pixels wide)
	0x00, 0x00, 0x00, //                     
	0x01, 0xFC, 0x00, //        #######      
	0x07, 0xFF, 0x00, //      ###########    
	0x1E, 0x07, 0x80, //    ####      ####   
	0x38, 0x01, 0xC0, //   ###          ###  
	0x30, 0xF6, 0xE0, //   ##    #### ## ### 
	0x61, 0xFE, 0x60, //  ##    ########  ## 
	0x63, 0x86, 0x70, //  ##   ###    ##  ###
	0xC7, 0x06, 0x30, // ##   ###     ##   ##
	0xC6, 0x06, 0x30, // ##   ##      ##   ##
	0xC6, 0x06, 0x30, // ##   ##      ##   ##
	0xC6, 0x06, 0x30, // ##   ##      ##   ##
	0xC6, 0x06, 0x30, // ##   ##      ##   ##
	0xC6, 0x06, 0x30, // ##   ##      ##   ##
	0x63, 0x0E, 0x60, //  ##   ##    ###  ## 
	0x63, 0xFF, 0xE0, //  ##   ############# 
	0x31, 0xF7, 0xE0, //   ##   ##### ###### 
	0x38, 0x00, 0x00, //   ###               
	0x1E, 0x00, 0x00, //    ####             
	0x07, 0xFE, 0x00, //      ##########     
	0x01, 0xFE, 0x00, //        ########     
	0x00, 0x00, 0x00, //                     
	0x00, 0x00, 0x00, //                     
	0x00, 0x00, 0x00, //                     

	// @1392 'A' (16 pixels wide)
	0x00, 0x00, //                 
	0x03, 0xC0, //       ####      
	0x03, 0xC0, //       ####      
	0x03, 0xC0, //       ####      
	0x06, 0x60, //      ##  ##     
	0x06, 0x60, //      ##  ##     
	0x0E, 0x30, //     ###   ##    
	0x0C, 0x30, //     ##    ##    
	0x0C, 0x30, //     ##    ##    
	0x18, 0x18, //    ##      ##   
	0x18, 0x18, //    ##      ##   
	0x18, 0x18, //    ##      ##   
	0x3F, 0xFC, //   ############  
	0x3F, 0xFC, //   ############  
	0x30, 0x0C, //   ##        ##  
	0x60, 0x06, //  ##          ## 
	0x60, 0x06, //  ##          ## 
	0x60, 0x06, //  ##          ## 
	0xC0, 0x03, // ##            ##
	0x00, 0x00, //                 
	0x00, 0x00, //                 
	0x00, 0x00, //                 
	0x00, 0x00, //                 
	0x00, 0x00, //                 

	// @1440 'B' (13 pixels wide)
	0x00, 0x00, //              
	0xFF, 0xC0, // ##########   
	0xFF, 0xE0, // ###########  
	0xC0, 0x70, // ##       ### 
	0xC0, 0x30, // ##        ## 
	0xC0, 0x30, // ##        ## 
	0xC0, 0x30, // ##        ## 
	0xC0, 0x60, // ##       ##  
	0xFF, 0xC0, // ##########   
	0xFF, 0xE0, // ###########  
	0xC0, 0x70, // ##       ### 
	0xC0, 0x18, // ##         ##
	0xC0, 0x18, // ##         ##
	0xC0, 0x18, // ##         ##
	0xC0, 0x18, // ##         ##
	0xC0, 0x38, // ##        ###
	0xC0, 0x70, // ##       ### 
	0xFF, 0xE0, // ###########  
	0xFF, 0xC0, // ##########   
	0x00, 0x00, //              
	0x00, 0x00, //              
	0x00, 0x00, //              
	0x00, 0x00, //              
	0x00, 0x00, //              

	// @1488 'C' (15 pixels wide)
	0x00, 0x00, //                
	0x03, 0xF8, //       #######  
	0x1F, 0xFE, //    ############
	0x3C, 0x0E, //   ####      ###
	0x70, 0x02, //  ###          #
	0x60, 0x00, //  ##            
	0x60, 0x00, //  ##            
	0xC0, 0x00, // ##             
	0xC0, 0x00, // ##             
	0xC0, 0x00, // ##             
	0xC0, 0x00, // ##             
	0xC0, 0x00, // ##             
	0xC0, 0x00, // ##             
	0xE0, 0x00, // ###            
	0x60, 0x00, //  ##            
	0x70, 0x02, //  ###          #
	0x3C, 0x0E, //   ####      ###
	0x1F, 0xFE, //    ############
	0x07, 0xF0, //      #######   
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                

	// @1536 'D' (16 pixels wide)
	0x00, 0x00, //                 
	0xFF, 0xC0, // ##########      
	0xFF, 0xF0, // ############    
	0xC0, 0x78, // ##       ####   
	0xC0, 0x1C, // ##         ###  
	0xC0, 0x0E, // ##          ### 
	0xC0, 0x06, // ##           ## 
	0xC0, 0x03, // ##            ##
	0xC0, 0x03, // ##            ##
	0xC0, 0x03, // ##            ##
	0xC0, 0x03, // ##            ##
	0xC0, 0x03, // ##            ##
	0xC0, 0x03, // ##            ##
	0xC0, 0x06, // ##           ## 
	0xC0, 0x06, // ##           ## 
	0xC0, 0x1C, // ##         ###  
	0xC0, 0x78, // ##       ####   
	0xFF, 0xF0, // ############    
	0xFF, 0xC0, // ##########      
	0x00, 0x00, //                 
	0x00, 0x00, //                 
	0x00, 0x00, //                 
	0x00, 0x00, //                 
	0x00, 0x00, //                 

	// @1584 'E' (12 pixels wide)
	0x00, 0x00, //             
	0xFF, 0xF0, // ############
	0xFF, 0xF0, // ############
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xFF, 0xF0, // ############
	0xFF, 0xF0, // ############
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xFF, 0xF0, // ############
	0xFF, 0xF0, // ############
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             

	// @1632 'F' (12 pixels wide)
	0x00, 0x00, //             
	0xFF, 0xF0, // ############
	0xFF, 0xF0, // ############
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xFF, 0xE0, // ########### 
	0xFF, 0xE0, // ########### 
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             

	// @1680 'G' (16 pixels wide)
	0x00, 0x00, //                 
	0x03, 0xF8, //       #######   
	0x0F, 0xFF, //     ############
	0x3C, 0x07, //   ####       ###
	0x30, 0x01, //   ##           #
	0x60, 0x00, //  ##             
	0x60, 0x00, //  ##             
	0xC0, 0x00, // ##              
	0xC0, 0x00, // ##              
	0xC0, 0x00, // ##              
	0xC0, 0x7F, // ##       #######
	0xC0, 0x7F, // ##       #######
	0xC0, 0x03, // ##            ##
	0x60, 0x03, //  ##           ##
	0x60, 0x03, //  ##           ##
	0x70, 0x03, //  ###          ##
	0x3C, 0x07, //   ####       ###
	0x0F, 0xFF, //     ############
	0x03, 0xF8, //       #######   
	0x00, 0x00, //                 
	0x00, 0x00, //                 
	0x00, 0x00, //                 
	0x00, 0x00, //                 
	0x00, 0x00, //                 

	// @1728 'H' (14 pixels wide)
	0x00, 0x00, //               
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xFF, 0xFC, // ##############
	0xFF, 0xFC, // ##############
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @1776 'I' (6 pixels wide)
	0x00, //       
	0xFC, // ######
	0xFC, // ######
	0x30, //   ##  
	0x30, //   ##  
	0x30, //   ##  
	0x30, //   ##  
	0x30, //   ##  
	0x30, //   ##  
	0x30, //   ##  
	0x30, //   ##  
	0x30, //   ##  
	0x30, //   ##  
	0x30, //   ##  
	0x30, //   ##  
	0x30, //   ##  
	0x30, //   ##  
	0xFC, // ######
	0xFC, // ######
	0x00, //       
	0x00, //       
	0x00, //       
	0x00, //       
	0x00, //       

	// @1800 'J' (8 pixels wide)
	0x00, //         
	0x3F, //   ######
	0x3F, //   ######
	0x03, //       ##
	0x03, //       ##
	0x03, //       ##
	0x03, //       ##
	0x03, //       ##
	0x03, //       ##
	0x03, //       ##
	0x03, //       ##
	0x03, //       ##
	0x03, //       ##
	0x03, //       ##
	0x03, //       ##
	0x03, //       ##
	0x87, // #    ###
	0xFE, // ####### 
	0xFC, // ######  
	0x00, //         
	0x00, //         
	0x00, //         
	0x00, //         
	0x00, //         

	// @1824 'K' (15 pixels wide)
	0x00, 0x00, //                
	0xC0, 0x0C, // ##          ## 
	0xC0, 0x18, // ##         ##  
	0xC0, 0x30, // ##        ##   
	0xC0, 0x60, // ##       ##    
	0xC1, 0xC0, // ##     ###     
	0xC3, 0x80, // ##    ###      
	0xC7, 0x00, // ##   ###       
	0xCE, 0x00, // ##  ###        
	0xDC, 0x00, // ## ###         
	0xFE, 0x00, // #######        
	0xE7, 0x00, // ###  ###       
	0xC3, 0x80, // ##    ###      
	0xC1, 0xC0, // ##     ###     
	0xC0, 0xE0, // ##      ###    
	0xC0, 0x70, // ##       ###   
	0xC0, 0x38, // ##        ###  
	0xC0, 0x1C, // ##         ### 
	0xC0, 0x0E, // ##          ###
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                

	// @1872 'L' (11 pixels wide)
	0x00, 0x00, //            
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xFF, 0xE0, // ###########
	0xFF, 0xE0, // ###########
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1920 'M' (16 pixels wide)
	0x00, 0x00, //                 
	0xE0, 0x07, // ###          ###
	0xF0, 0x0F, // ####        ####
	0xF0, 0x0F, // ####        ####
	0xD8, 0x1B, // ## ##      ## ##
	0xD8, 0x1B, // ## ##      ## ##
	0xCC, 0x33, // ##  ##    ##  ##
	0xCC, 0x33, // ##  ##    ##  ##
	0xCE, 0x63, // ##  ###  ##   ##
	0xC6, 0x63, // ##   ##  ##   ##
	0xC7, 0xC3, // ##   #####    ##
	0xC3, 0xC3, // ##    ####    ##
	0xC3, 0x83, // ##    ###     ##
	0xC1, 0x83, // ##     ##     ##
	0xC0, 0x03, // ##            ##
	0xC0, 0x03, // ##            ##
	0xC0, 0x03, // ##            ##
	0xC0, 0x03, // ##            ##
	0xC0, 0x03, // ##            ##
	0x00, 0x00, //                 
	0x00, 0x00, //                 
	0x00, 0x00, //                 
	0x00, 0x00, //                 
	0x00, 0x00, //                 

	// @1968 'N' (14 pixels wide)
	0x00, 0x00, //               
	0xF0, 0x0C, // ####        ##
	0xF0, 0x0C, // ####        ##
	0xF8, 0x0C, // #####       ##
	0xDC, 0x0C, // ## ###      ##
	0xDC, 0x0C, // ## ###      ##
	0xCE, 0x0C, // ##  ###     ##
	0xC6, 0x0C, // ##   ##     ##
	0xC7, 0x0C, // ##   ###    ##
	0xC3, 0x0C, // ##    ##    ##
	0xC3, 0x8C, // ##    ###   ##
	0xC1, 0xCC, // ##     ###  ##
	0xC1, 0xCC, // ##     ###  ##
	0xC0, 0xEC, // ##      ### ##
	0xC0, 0x6C, // ##       ## ##
	0xC0, 0x7C, // ##       #####
	0xC0, 0x3C, // ##        ####
	0xC0, 0x3C, // ##        ####
	0xC0, 0x1C, // ##         ###
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2016 'O' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x07, 0xF0, 0x00, //      #######     
	0x1F, 0xFC, 0x00, //    ###########   
	0x3C, 0x1E, 0x00, //   ####     ####  
	0x70, 0x07, 0x00, //  ###         ### 
	0x60, 0x03, 0x00, //  ##           ## 
	0xE0, 0x03, 0x80, // ###           ###
	0xC0, 0x01, 0x80, // ##             ##
	0xC0, 0x01, 0x80, // ##             ##
	0xC0, 0x01, 0x80, // ##             ##
	0xC0, 0x01, 0x80, // ##             ##
	0xC0, 0x01, 0x80, // ##             ##
	0xC0, 0x01, 0x80, // ##             ##
	0xE0, 0x03, 0x80, // ###           ###
	0x60, 0x03, 0x00, //  ##           ## 
	0x70, 0x07, 0x00, //  ###         ### 
	0x3C, 0x1E, 0x00, //   ####     ####  
	0x1F, 0xFC, 0x00, //    ###########   
	0x07, 0xF0, 0x00, //      #######     
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  
	0x00, 0x00, 0x00, //                  

	// @2088 'P' (11 pixels wide)
	0x00, 0x00, //            
	0xFF, 0x00, // ########   
	0xFF, 0x80, // #########  
	0xC1, 0xC0, // ##     ### 
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0xE0, // ##      ###
	0xC1, 0xC0, // ##     ### 
	0xFF, 0x80, // #########  
	0xFE, 0x00, // #######    
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2136 'Q' (17 pixels wide)
	0x00, 0x00, 0x00, //                  
	0x07, 0xF0, 0x00, //      #######     
	0x1F, 0xFC, 0x00, //    ###########   
	0x3C, 0x1E, 0x00, //   ####     ####  
	0x70, 0x07, 0x00, //  ###         ### 
	0x60, 0x03, 0x00, //  ##           ## 
	0xE0, 0x03, 0x80, // ###           ###
	0xC0, 0x01, 0x80, // ##             ##
	0xC0, 0x01, 0x80, // ##             ##
	0xC0, 0x01, 0x80, // ##             ##
	0xC0, 0x01, 0x80, // ##             ##
	0xC0, 0x01, 0x80, // ##             ##
	0xC0, 0x01, 0x80, // ##             ##
	0xE0, 0x03, 0x00, // ###           ## 
	0x60, 0x03, 0x00, //  ##           ## 
	0x70, 0x07, 0x00, //  ###         ### 
	0x3C, 0x1E, 0x00, //   ####     ####  
	0x1F, 0xFC, 0x00, //    ###########   
	0x07, 0xF0, 0x00, //      #######     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x30, 0x00, //           ##     
	0x00, 0x18, 0x00, //            ##    
	0x00, 0x1F, 0x80, //            ######
	0x00, 0x0F, 0x80, //             #####

	// @2208 'R' (14 pixels wide)
	0x00, 0x00, //               
	0xFF, 0x00, // ########      
	0xFF, 0xC0, // ##########    
	0xC0, 0xC0, // ##      ##    
	0xC0, 0x60, // ##       ##   
	0xC0, 0x60, // ##       ##   
	0xC0, 0x60, // ##       ##   
	0xC0, 0x60, // ##       ##   
	0xC0, 0xE0, // ##      ###   
	0xC1, 0xC0, // ##     ###    
	0xFF, 0x80, // #########     
	0xFF, 0x00, // ########      
	0xC3, 0x80, // ##    ###     
	0xC1, 0x80, // ##     ##     
	0xC0, 0xC0, // ##      ##    
	0xC0, 0x60, // ##       ##   
	0xC0, 0x70, // ##       ###  
	0xC0, 0x38, // ##        ### 
	0xC0, 0x1C, // ##         ###
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2256 'S' (13 pixels wide)
	0x00, 0x00, //              
	0x1F, 0xC0, //    #######   
	0x3F, 0xF0, //   ########## 
	0x70, 0x70, //  ###     ### 
	0xC0, 0x10, // ##         # 
	0xC0, 0x00, // ##           
	0xC0, 0x00, // ##           
	0xE0, 0x00, // ###          
	0x78, 0x00, //  ####        
	0x3F, 0xC0, //   ########   
	0x0F, 0xF0, //     ######## 
	0x00, 0x78, //          ####
	0x00, 0x18, //            ##
	0x00, 0x18, //            ##
	0x00, 0x18, //            ##
	0x80, 0x18, // #          ##
	0xE0, 0x70, // ###      ### 
	0xFF, 0xE0, // ###########  
	0x3F, 0x80, //   #######    
	0x00, 0x00, //              
	0x00, 0x00, //              
	0x00, 0x00, //              
	0x00, 0x00, //              
	0x00, 0x00, //              

	// @2304 'T' (14 pixels wide)
	0x00, 0x00, //               
	0xFF, 0xFC, // ##############
	0xFF, 0xFC, // ##############
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2352 'U' (14 pixels wide)
	0x00, 0x00, //               
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0xC0, 0x0C, // ##          ##
	0x60, 0x18, //  ##        ## 
	0x70, 0x38, //  ###      ### 
	0x3F, 0xF0, //   ##########  
	0x0F, 0xC0, //     ######    
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2400 'V' (16 pixels wide)
	0x00, 0x00, //                 
	0xC0, 0x03, // ##            ##
	0x60, 0x06, //  ##          ## 
	0x60, 0x06, //  ##          ## 
	0x60, 0x06, //  ##          ## 
	0x30, 0x0C, //   ##        ##  
	0x30, 0x0C, //   ##        ##  
	0x30, 0x0C, //   ##        ##  
	0x18, 0x18, //    ##      ##   
	0x18, 0x18, //    ##      ##   
	0x18, 0x18, //    ##      ##   
	0x0C, 0x30, //     ##    ##    
	0x0C, 0x30, //     ##    ##    
	0x0E, 0x70, //     ###  ###    
	0x06, 0x60, //      ##  ##     
	0x06, 0x60, //      ##  ##     
	0x03, 0xC0, //       ####      
	0x03, 0xC0, //       ####      
	0x03, 0xC0, //       ####      
	0x00, 0x00, //                 
	0x00, 0x00, //                 
	0x00, 0x00, //                 
	0x00, 0x00, //                 
	0x00, 0x00, //                 

	// @2448 'W' (22 pixels wide)
	0x00, 0x00, 0x00, //                       
	0xC0, 0x30, 0x0C, // ##        ##        ##
	0xC0, 0x78, 0x0C, // ##       ####       ##
	0x60, 0x78, 0x18, //  ##      ####      ## 
	0x60, 0x78, 0x18, //  ##      ####      ## 
	0x60, 0x78, 0x18, //  ##      ####      ## 
	0x70, 0xCC, 0x38, //  ###    ##  ##    ### 
	0x30, 0xCC, 0x30, //   ##    ##  ##    ##  
	0x30, 0xCC, 0x30, //   ##    ##  ##    ##  
	0x30, 0xCC, 0x30, //   ##    ##  ##    ##  
	0x38, 0x86, 0x70, //   ###   #    ##  ###  
	0x19, 0x86, 0x60, //    ##  ##    ##  ##   
	0x19, 0x86, 0x60, //    ##  ##    ##  ##   
	0x19, 0x86, 0x60, //    ##  ##    ##  ##   
	0x0D, 0x03, 0xE0, //     ## #      #####   
	0x0F, 0x03, 0xC0, //     ####      ####    
	0x0F, 0x03, 0xC0, //     ####      ####    
	0x0F, 0x03, 0xC0, //     ####      ####    
	0x06, 0x01, 0xC0, //      ##        ###    
	0x00, 0x00, 0x00, //                       
	0x00, 0x00, 0x00, //                       
	0x00, 0x00, 0x00, //                       
	0x00, 0x00, 0x00, //                       
	0x00, 0x00, 0x00, //                       

	// @2520 'X' (14 pixels wide)
	0x00, 0x00, //               
	0xE0, 0x1C, // ###        ###
	0x60, 0x18, //  ##        ## 
	0x30, 0x30, //   ##      ##  
	0x38, 0x70, //   ###    ###  
	0x18, 0x60, //    ##    ##   
	0x0C, 0xC0, //     ##  ##    
	0x0E, 0xC0, //     ### ##    
	0x07, 0x80, //      ####     
	0x07, 0x80, //      ####     
	0x07, 0x80, //      ####     
	0x07, 0x80, //      ####     
	0x0C, 0xC0, //     ##  ##    
	0x0C, 0xE0, //     ##  ###   
	0x18, 0x60, //    ##    ##   
	0x38, 0x70, //   ###    ###  
	0x30, 0x30, //   ##      ##  
	0x60, 0x18, //  ##        ## 
	0xE0, 0x1C, // ###        ###
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2568 'Y' (14 pixels wide)
	0x00, 0x00, //               
	0xE0, 0x1C, // ###        ###
	0x60, 0x18, //  ##        ## 
	0x70, 0x38, //  ###      ### 
	0x30, 0x30, //   ##      ##  
	0x18, 0x60, //    ##    ##   
	0x1C, 0xE0, //    ###  ###   
	0x0C, 0xC0, //     ##  ##    
	0x0F, 0xC0, //     ######    
	0x07, 0x80, //      ####     
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x03, 0x00, //       ##      
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2616 'Z' (14 pixels wide)
	0x00, 0x00, //               
	0xFF, 0xFC, // ##############
	0xFF, 0xFC, // ##############
	0x00, 0x1C, //            ###
	0x00, 0x38, //           ### 
	0x00, 0x70, //          ###  
	0x00, 0x60, //          ##   
	0x00, 0xC0, //         ##    
	0x01, 0x80, //        ##     
	0x03, 0x80, //       ###     
	0x07, 0x00, //      ###      
	0x06, 0x00, //      ##       
	0x0C, 0x00, //     ##        
	0x18, 0x00, //    ##         
	0x38, 0x00, //   ###         
	0x70, 0x00, //  ###          
	0xE0, 0x00, // ###           
	0xFF, 0xFC, // ##############
	0xFF, 0xFC, // ##############
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               
	0x00, 0x00, //               

	// @2664 '[' (6 pixels wide)
	0xFC, // ######
	0xFC, // ######
	0xC0, // ##    
	0xC0, // ##    
	0xC0, // ##    
	0xC0, // ##    
	0xC0, // ##    
	0xC0, // ##    
	0xC0, // ##    
	0xC0, // ##    
	0xC0, // ##    
	0xC0, // ##    
	0xC0, // ##    
	0xC0, // ##    
	0xC0, // ##    
	0xC0, // ##    
	0xC0, // ##    
	0xC0, // ##    
	0xC0, // ##    
	0xC0, // ##    
	0xC0, // ##    
	0xC0, // ##    
	0xFC, // ######
	0xFC, // ######

	// @2688 '\' (10 pixels wide)
	0xC0, 0x00, // ##        
	0x60, 0x00, //  ##       
	0x60, 0x00, //  ##       
	0x60, 0x00, //  ##       
	0x30, 0x00, //   ##      
	0x30, 0x00, //   ##      
	0x30, 0x00, //   ##      
	0x18, 0x00, //    ##     
	0x18, 0x00, //    ##     
	0x18, 0x00, //    ##     
	0x0C, 0x00, //     ##    
	0x0C, 0x00, //     ##    
	0x0C, 0x00, //     ##    
	0x06, 0x00, //      ##   
	0x06, 0x00, //      ##   
	0x06, 0x00, //      ##   
	0x03, 0x00, //       ##  
	0x03, 0x00, //       ##  
	0x03, 0x00, //       ##  
	0x01, 0x80, //        ## 
	0x01, 0x80, //        ## 
	0x01, 0x80, //        ## 
	0x00, 0xC0, //         ##
	0x00, 0x00, //           

	// @2736 ']' (6 pixels wide)
	0xFC, // ######
	0xFC, // ######
	0x0C, //     ##
	0x0C, //     ##
	0x0C, //     ##
	0x0C, //     ##
	0x0C, //     ##
	0x0C, //     ##
	0x0C, //     ##
	0x0C, //     ##
	0x0C, //     ##
	0x0C, //     ##
	0x0C, //     ##
	0x0C, //     ##
	0x0C, //     ##
	0x0C, //     ##
	0x0C, //     ##
	0x0C, //     ##
	0x0C, //     ##
	0x0C, //     ##
	0x0C, //     ##
	0x0C, //     ##
	0xFC, // ######
	0xFC, // ######

	// @2760 '^' (15 pixels wide)
	0x00, 0x00, //                
	0x03, 0x80, //       ###      
	0x03, 0x80, //       ###      
	0x06, 0xC0, //      ## ##     
	0x0C, 0x60, //     ##   ##    
	0x1C, 0x70, //    ###   ###   
	0x18, 0x30, //    ##     ##   
	0x30, 0x18, //   ##       ##  
	0x60, 0x0C, //  ##         ## 
	0xE0, 0x0E, // ###         ###
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                

	// @2808 '_' (15 pixels wide)
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0xFF, 0xFE, // ###############
	0x00, 0x00, //                
	0x00, 0x00, //                

	// @2856 '`' (5 pixels wide)
	0xE0, // ###  
	0x70, //  ### 
	0x30, //   ## 
	0x18, //    ##
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      
	0x00, //      

	// @2880 'a' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x3F, 0x80, //   #######  
	0x7F, 0xC0, //  ######### 
	0x40, 0xE0, //  #      ###
	0x00, 0x60, //          ##
	0x0F, 0xE0, //     #######
	0x3F, 0xE0, //   #########
	0x70, 0x60, //  ###     ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xE1, 0xE0, // ###    ####
	0x7F, 0xE0, //  ##########
	0x3E, 0x60, //   #####  ##
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2928 'b' (12 pixels wide)
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xCF, 0x80, // ##  #####   
	0xFF, 0xC0, // ##########  
	0xF0, 0xE0, // ####    ### 
	0xC0, 0x70, // ##       ###
	0xC0, 0x30, // ##        ##
	0xC0, 0x30, // ##        ##
	0xC0, 0x30, // ##        ##
	0xC0, 0x30, // ##        ##
	0xC0, 0x30, // ##        ##
	0xC0, 0x60, // ##       ## 
	0xE0, 0xE0, // ###     ### 
	0xFF, 0xC0, // ##########  
	0xDF, 0x00, // ## #####    
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             

	// @2976 'c' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x0F, 0x80, //     #####  
	0x3F, 0xE0, //   #########
	0x70, 0x60, //  ###     ##
	0x60, 0x20, //  ##       #
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0x60, 0x20, //  ##       #
	0x70, 0x60, //  ###     ##
	0x3F, 0xE0, //   #########
	0x0F, 0x80, //     #####  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @3024 'd' (12 pixels wide)
	0x00, 0x30, //           ##
	0x00, 0x30, //           ##
	0x00, 0x30, //           ##
	0x00, 0x30, //           ##
	0x00, 0x30, //           ##
	0x00, 0x30, //           ##
	0x0F, 0xB0, //     ##### ##
	0x3F, 0xF0, //   ##########
	0x70, 0x30, //  ###      ##
	0x60, 0x30, //  ##       ##
	0xC0, 0x30, // ##        ##
	0xC0, 0x30, // ##        ##
	0xC0, 0x30, // ##        ##
	0xC0, 0x30, // ##        ##
	0xC0, 0x30, // ##        ##
	0xE0, 0x30, // ###       ##
	0x70, 0xF0, //  ###    ####
	0x3F, 0xF0, //   ##########
	0x1F, 0x30, //    #####  ##
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             

	// @3072 'e' (12 pixels wide)
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x0F, 0x80, //     #####   
	0x3F, 0xE0, //   ######### 
	0x70, 0x60, //  ###     ## 
	0x60, 0x30, //  ##       ##
	0xC0, 0x30, // ##        ##
	0xFF, 0xF0, // ############
	0xFF, 0xF0, // ############
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0x60, 0x10, //  ##        #
	0x70, 0x70, //  ###     ###
	0x3F, 0xF0, //   ##########
	0x0F, 0xC0, //     ######  
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             

	// @3120 'f' (8 pixels wide)
	0x1F, //    #####
	0x3F, //   ######
	0x30, //   ##    
	0x60, //  ##     
	0x60, //  ##     
	0x60, //  ##     
	0xFE, // ####### 
	0xFE, // ####### 
	0x60, //  ##     
	0x60, //  ##     
	0x60, //  ##     
	0x60, //  ##     
	0x60, //  ##     
	0x60, //  ##     
	0x60, //  ##     
	0x60, //  ##     
	0x60, //  ##     
	0x60, //  ##     
	0x60, //  ##     
	0x00, //         
	0x00, //         
	0x00, //         
	0x00, //         
	0x00, //         

	// @3144 'g' (12 pixels wide)
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x0F, 0xB0, //     ##### ##
	0x3F, 0xF0, //   ##########
	0x70, 0x70, //  ###     ###
	0x60, 0x30, //  ##       ##
	0xC0, 0x30, // ##        ##
	0xC0, 0x30, // ##        ##
	0xC0, 0x30, // ##        ##
	0xC0, 0x30, // ##        ##
	0xC0, 0x30, // ##        ##
	0xE0, 0x30, // ###       ##
	0x70, 0xF0, //  ###    ####
	0x3F, 0xF0, //   ##########
	0x1F, 0x30, //    #####  ##
	0x00, 0x30, //           ##
	0x00, 0x30, //           ##
	0x60, 0xE0, //  ##     ### 
	0x7F, 0xC0, //  #########  
	0x7F, 0x80, //  ########   

	// @3192 'h' (11 pixels wide)
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0xCF, 0x80, // ##  #####  
	0xFF, 0xC0, // ########## 
	0xF0, 0xE0, // ####    ###
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @3240 'i' (2 pixels wide)
	0x00, //   
	0xC0, // ##
	0xC0, // ##
	0x00, //   
	0x00, //   
	0x00, //   
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   

	// @3264 'j' (7 pixels wide)
	0x00, //        
	0x06, //      ##
	0x06, //      ##
	0x00, //        
	0x00, //        
	0x00, //        
	0x3E, //   #####
	0x3E, //   #####
	0x06, //      ##
	0x06, //      ##
	0x06, //      ##
	0x06, //      ##
	0x06, //      ##
	0x06, //      ##
	0x06, //      ##
	0x06, //      ##
	0x06, //      ##
	0x06, //      ##
	0x06, //      ##
	0x06, //      ##
	0x06, //      ##
	0x0E, //     ###
	0xFC, // ###### 
	0xF8, // #####  

	// @3288 'k' (12 pixels wide)
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x60, // ##       ## 
	0xC0, 0xC0, // ##      ##  
	0xC1, 0x80, // ##     ##   
	0xC3, 0x00, // ##    ##    
	0xC6, 0x00, // ##   ##     
	0xCC, 0x00, // ##  ##      
	0xDC, 0x00, // ## ###      
	0xEE, 0x00, // ### ###     
	0xC7, 0x00, // ##   ###    
	0xC3, 0x80, // ##    ###   
	0xC1, 0xC0, // ##     ###  
	0xC0, 0xE0, // ##      ### 
	0xC0, 0x70, // ##       ###
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             

	// @3336 'l' (2 pixels wide)
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   
	0x00, //   

	// @3360 'm' (18 pixels wide)
	0x00, 0x00, 0x00, //                   
	0x00, 0x00, 0x00, //                   
	0x00, 0x00, 0x00, //                   
	0x00, 0x00, 0x00, //                   
	0x00, 0x00, 0x00, //                   
	0x00, 0x00, 0x00, //                   
	0xCF, 0x0F, 0x00, // ##  ####    ####  
	0xFF, 0xBF, 0x80, // ######### ####### 
	0xF1, 0xF1, 0xC0, // ####   #####   ###
	0xC0, 0xC0, 0xC0, // ##      ##      ##
	0xC0, 0xC0, 0xC0, // ##      ##      ##
	0xC0, 0xC0, 0xC0, // ##      ##      ##
	0xC0, 0xC0, 0xC0, // ##      ##      ##
	0xC0, 0xC0, 0xC0, // ##      ##      ##
	0xC0, 0xC0, 0xC0, // ##      ##      ##
	0xC0, 0xC0, 0xC0, // ##      ##      ##
	0xC0, 0xC0, 0xC0, // ##      ##      ##
	0xC0, 0xC0, 0xC0, // ##      ##      ##
	0xC0, 0xC0, 0xC0, // ##      ##      ##
	0x00, 0x00, 0x00, //                   
	0x00, 0x00, 0x00, //                   
	0x00, 0x00, 0x00, //                   
	0x00, 0x00, 0x00, //                   
	0x00, 0x00, 0x00, //                   

	// @3432 'n' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0xCF, 0x80, // ##  #####  
	0xFF, 0xC0, // ########## 
	0xF0, 0xE0, // ####    ###
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @3480 'o' (13 pixels wide)
	0x00, 0x00, //              
	0x00, 0x00, //              
	0x00, 0x00, //              
	0x00, 0x00, //              
	0x00, 0x00, //              
	0x00, 0x00, //              
	0x0F, 0x80, //     #####    
	0x3F, 0xE0, //   #########  
	0x70, 0x70, //  ###     ### 
	0x60, 0x30, //  ##       ## 
	0xC0, 0x18, // ##         ##
	0xC0, 0x18, // ##         ##
	0xC0, 0x18, // ##         ##
	0xC0, 0x18, // ##         ##
	0xC0, 0x18, // ##         ##
	0x60, 0x30, //  ##       ## 
	0x70, 0x70, //  ###     ### 
	0x3F, 0xE0, //   #########  
	0x0F, 0x80, //     #####    
	0x00, 0x00, //              
	0x00, 0x00, //              
	0x00, 0x00, //              
	0x00, 0x00, //              
	0x00, 0x00, //              

	// @3528 'p' (12 pixels wide)
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0xCF, 0x80, // ##  #####   
	0xFF, 0xC0, // ##########  
	0xF0, 0xE0, // ####    ### 
	0xC0, 0x70, // ##       ###
	0xC0, 0x30, // ##        ##
	0xC0, 0x30, // ##        ##
	0xC0, 0x30, // ##        ##
	0xC0, 0x30, // ##        ##
	0xC0, 0x30, // ##        ##
	0xC0, 0x60, // ##       ## 
	0xC0, 0xE0, // ##      ### 
	0xFF, 0xC0, // ##########  
	0xDF, 0x00, // ## #####    
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          
	0xC0, 0x00, // ##          

	// @3576 'q' (12 pixels wide)
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x0F, 0xB0, //     ##### ##
	0x3F, 0xF0, //   ##########
	0x70, 0x70, //  ###     ###
	0x60, 0x30, //  ##       ##
	0xC0, 0x30, // ##        ##
	0xC0, 0x30, // ##        ##
	0xC0, 0x30, // ##        ##
	0xC0, 0x30, // ##        ##
	0xC0, 0x30, // ##        ##
	0xE0, 0x30, // ###       ##
	0x70, 0xF0, //  ###    ####
	0x3F, 0xF0, //   ##########
	0x1F, 0x30, //    #####  ##
	0x00, 0x30, //           ##
	0x00, 0x30, //           ##
	0x00, 0x30, //           ##
	0x00, 0x30, //           ##
	0x00, 0x30, //           ##

	// @3624 'r' (8 pixels wide)
	0x00, //         
	0x00, //         
	0x00, //         
	0x00, //         
	0x00, //         
	0x00, //         
	0xCF, // ##  ####
	0xDF, // ## #####
	0xF0, // ####    
	0xC0, // ##      
	0xC0, // ##      
	0xC0, // ##      
	0xC0, // ##      
	0xC0, // ##      
	0xC0, // ##      
	0xC0, // ##      
	0xC0, // ##      
	0xC0, // ##      
	0xC0, // ##      
	0x00, //         
	0x00, //         
	0x00, //         
	0x00, //         
	0x00, //         

	// @3648 's' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1F, 0x80, //    ######  
	0x7F, 0xC0, //  ######### 
	0xE0, 0x40, // ###      # 
	0xC0, 0x00, // ##         
	0xC0, 0x00, // ##         
	0x7C, 0x00, //  #####     
	0x3F, 0x80, //   #######  
	0x03, 0xE0, //       #####
	0x00, 0x60, //          ##
	0x80, 0x60, // #        ##
	0xE0, 0xE0, // ###     ###
	0xFF, 0xC0, // ########## 
	0x3F, 0x00, //   ######   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @3696 't' (7 pixels wide)
	0x00, //        
	0x00, //        
	0x60, //  ##    
	0x60, //  ##    
	0x60, //  ##    
	0x60, //  ##    
	0xFE, // #######
	0xFE, // #######
	0x60, //  ##    
	0x60, //  ##    
	0x60, //  ##    
	0x60, //  ##    
	0x60, //  ##    
	0x60, //  ##    
	0x60, //  ##    
	0x60, //  ##    
	0x70, //  ###   
	0x3E, //   #####
	0x1E, //    ####
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        
	0x00, //        

	// @3720 'u' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0xE1, 0xE0, // ###    ####
	0x7F, 0xE0, //  ##########
	0x3E, 0x60, //   #####  ##
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @3768 'v' (12 pixels wide)
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0xC0, 0x30, // ##        ##
	0x60, 0x60, //  ##      ## 
	0x60, 0x60, //  ##      ## 
	0x60, 0x60, //  ##      ## 
	0x30, 0xC0, //   ##    ##  
	0x30, 0xC0, //   ##    ##  
	0x39, 0xC0, //   ###  ###  
	0x19, 0x80, //    ##  ##   
	0x19, 0x80, //    ##  ##   
	0x0F, 0x00, //     ####    
	0x0F, 0x00, //     ####    
	0x0F, 0x00, //     ####    
	0x06, 0x00, //      ##     
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             

	// @3816 'w' (18 pixels wide)
	0x00, 0x00, 0x00, //                   
	0x00, 0x00, 0x00, //                   
	0x00, 0x00, 0x00, //                   
	0x00, 0x00, 0x00, //                   
	0x00, 0x00, 0x00, //                   
	0x00, 0x00, 0x00, //                   
	0xC0, 0xC0, 0xC0, // ##      ##      ##
	0xC0, 0xE0, 0xC0, // ##      ###     ##
	0x61, 0xE1, 0x80, //  ##    ####    ## 
	0x61, 0xE1, 0x80, //  ##    ####    ## 
	0x61, 0x31, 0x80, //  ##    #  ##   ## 
	0x73, 0x31, 0x80, //  ###  ##  ##   ## 
	0x33, 0x33, 0x00, //   ##  ##  ##  ##  
	0x32, 0x1B, 0x00, //   ##  #    ## ##  
	0x36, 0x1B, 0x00, //   ## ##    ## ##  
	0x1E, 0x1A, 0x00, //    ####    ## #   
	0x1C, 0x0E, 0x00, //    ###      ###   
	0x1C, 0x0E, 0x00, //    ###      ###   
	0x1C, 0x0E, 0x00, //    ###      ###   
	0x00, 0x00, 0x00, //                   
	0x00, 0x00, 0x00, //                   
	0x00, 0x00, 0x00, //                   
	0x00, 0x00, 0x00, //                   
	0x00, 0x00, 0x00, //                   

	// @3888 'x' (12 pixels wide)
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0xE0, 0x70, // ###      ###
	0x70, 0xE0, //  ###    ### 
	0x30, 0xC0, //   ##    ##  
	0x19, 0x80, //    ##  ##   
	0x1F, 0x80, //    ######   
	0x0F, 0x00, //     ####    
	0x06, 0x00, //      ##     
	0x0F, 0x00, //     ####    
	0x1F, 0x80, //    ######   
	0x19, 0x80, //    ##  ##   
	0x30, 0xC0, //   ##    ##  
	0x70, 0xE0, //  ###    ### 
	0xE0, 0x70, // ###      ###
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             

	// @3936 'y' (12 pixels wide)
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0x00, 0x00, //             
	0xC0, 0x30, // ##        ##
	0x60, 0x60, //  ##      ## 
	0x60, 0x60, //  ##      ## 
	0x70, 0xE0, //  ###    ### 
	0x30, 0xC0, //   ##    ##  
	0x30, 0xC0, //   ##    ##  
	0x19, 0x80, //    ##  ##   
	0x19, 0x80, //    ##  ##   
	0x1F, 0x80, //    ######   
	0x0F, 0x00, //     ####    
	0x0F, 0x00, //     ####    
	0x06, 0x00, //      ##     
	0x06, 0x00, //      ##     
	0x0E, 0x00, //     ###     
	0x0C, 0x00, //     ##      
	0x0C, 0x00, //     ##      
	0x18, 0x00, //    ##       
	0x18, 0x00, //    ##       

	// @3984 'z' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0xFF, 0xE0, // ###########
	0xFF, 0xE0, // ###########
	0x00, 0xE0, //         ###
	0x01, 0xC0, //        ### 
	0x03, 0x80, //       ###  
	0x07, 0x00, //      ###   
	0x0E, 0x00, //     ###    
	0x1C, 0x00, //    ###     
	0x38, 0x00, //   ###      
	0x70, 0x00, //  ###       
	0xE0, 0x00, // ###        
	0xFF, 0xE0, // ###########
	0xFF, 0xE0, // ###########
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @4032 '{' (11 pixels wide)
	0x01, 0xE0, //        ####
	0x03, 0xE0, //       #####
	0x07, 0x00, //      ###   
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x0C, 0x00, //     ##     
	0x1C, 0x00, //    ###     
	0xF0, 0x00, // ####       
	0xF0, 0x00, // ####       
	0x1C, 0x00, //    ###     
	0x0C, 0x00, //     ##     
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x07, 0x00, //      ###   
	0x03, 0xE0, //       #####
	0x01, 0xE0, //        ####

	// @4080 '|' (2 pixels wide)
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##
	0xC0, // ##

	// @4104 '}' (11 pixels wide)
	0xF0, 0x00, // ####       
	0xF8, 0x00, // #####      
	0x1C, 0x00, //    ###     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x06, 0x00, //      ##    
	0x07, 0x00, //      ###   
	0x01, 0xE0, //        ####
	0x01, 0xE0, //        ####
	0x07, 0x00, //      ###   
	0x06, 0x00, //      ##    
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x1C, 0x00, //    ###     
	0xF8, 0x00, // #####      
	0xF0, 0x00, // ####       

	// @4152 '~' (15 pixels wide)
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x3C, 0x06, //   ####       ##
	0x7E, 0x06, //  ######      ##
	0x63, 0x06, //  ##   ##     ##
	0xC1, 0x8C, // ##     ##   ## 
	0xC0, 0xFC, // ##      ###### 
	0xC0, 0x78, // ##       ####  
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
	0x00, 0x00, //                
};

// Character descriptors for Verdana 18pt
// { [Char width in bits], [Char height in bits], [Offset into verdana_18ptCharBitmaps in bytes] }
const FONT_CHAR_INFO verdana_18ptDescriptors[] = 
{
	{2, 24, 0}, 		//   
	{2, 24, 24}, 		// ! 
	{7, 24, 48}, 		// " 
	{15, 24, 72}, 		// # 
	{11, 24, 120}, 		// $ 
	{22, 24, 168}, 		// % 
	{17, 24, 240}, 		// & 
	{2, 24, 312}, 		// ' 
	{7, 24, 336}, 		// ( 
	{7, 24, 360}, 		// ) 
	{12, 24, 384}, 		// * 
	{14, 24, 432}, 		// + 
	{5, 24, 480}, 		// , 
	{7, 24, 504}, 		// - 
	{3, 24, 528}, 		// . 
	{10, 24, 552}, 		// / 
	{11, 24, 600}, 		// 0 
	{10, 24, 648}, 		// 1 
	{11, 24, 696}, 		// 2 
	{11, 24, 744}, 		// 3 
	{14, 24, 792}, 		// 4 
	{11, 24, 840}, 		// 5 
	{11, 24, 888}, 		// 6 
	{12, 24, 936}, 		// 7 
	{11, 24, 984}, 		// 8 
	{11, 24, 1032}, 		// 9 
	{3, 24, 1080}, 		// : 
	{5, 24, 1104}, 		// ; 
	{14, 24, 1128}, 		// < 
	{14, 24, 1176}, 		// = 
	{14, 24, 1224}, 		// > 
	{10, 24, 1272}, 		// ? 
	{20, 24, 1320}, 		// @ 
	{16, 24, 1392}, 		// A 
	{13, 24, 1440}, 		// B 
	{15, 24, 1488}, 		// C 
	{16, 24, 1536}, 		// D 
	{12, 24, 1584}, 		// E 
	{12, 24, 1632}, 		// F 
	{16, 24, 1680}, 		// G 
	{14, 24, 1728}, 		// H 
	{6, 24, 1776}, 		// I 
	{8, 24, 1800}, 		// J 
	{15, 24, 1824}, 		// K 
	{11, 24, 1872}, 		// L 
	{16, 24, 1920}, 		// M 
	{14, 24, 1968}, 		// N 
	{17, 24, 2016}, 		// O 
	{11, 24, 2088}, 		// P 
	{17, 24, 2136}, 		// Q 
	{14, 24, 2208}, 		// R 
	{13, 24, 2256}, 		// S 
	{14, 24, 2304}, 		// T 
	{14, 24, 2352}, 		// U 
	{16, 24, 2400}, 		// V 
	{22, 24, 2448}, 		// W 
	{14, 24, 2520}, 		// X 
	{14, 24, 2568}, 		// Y 
	{14, 24, 2616}, 		// Z 
	{6, 24, 2664}, 		// [ 
	{10, 24, 2688}, 		// Backslash
	{6, 24, 2736}, 		// ] 
	{15, 24, 2760}, 		// ^ 
	{15, 24, 2808}, 		// _ 
	{5, 24, 2856}, 		// ` 
	{11, 24, 2880}, 		// a 
	{12, 24, 2928}, 		// b 
	{11, 24, 2976}, 		// c 
	{12, 24, 3024}, 		// d 
	{12, 24, 3072}, 		// e 
	{8, 24, 3120}, 		// f 
	{12, 24, 3144}, 		// g 
	{11, 24, 3192}, 		// h 
	{2, 24, 3240}, 		// i 
	{7, 24, 3264}, 		// j 
	{12, 24, 3288}, 		// k 
	{2, 24, 3336}, 		// l 
	{18, 24, 3360}, 		// m 
	{11, 24, 3432}, 		// n 
	{13, 24, 3480}, 		// o 
	{12, 24, 3528}, 		// p 
	{12, 24, 3576}, 		// q 
	{8, 24, 3624}, 		// r 
	{11, 24, 3648}, 		// s 
	{7, 24, 3696}, 		// t 
	{11, 24, 3720}, 		// u 
	{12, 24, 3768}, 		// v 
	{18, 24, 3816}, 		// w 
	{12, 24, 3888}, 		// x 
	{12, 24, 3936}, 		// y 
	{11, 24, 3984}, 		// z 
	{11, 24, 4032}, 		// { 
	{2, 24, 4080}, 		// | 
	{11, 24, 4104}, 		// } 
	{15, 24, 4152}, 		// ~ 
};

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wdiscarded-qualifiers"

// Font information for Verdana 18pt
FONT_INFO verdana_18ptFontInfo =
{
	' ', //  Start character
	'~', //  End character
	verdana_18ptDescriptors, //  Character descriptor array
	verdana_18ptBitmaps, //  Character bitmap array
};

#pragma GCC diagnostic pop
