//
//Font data for Verdana 12pt
//

#include <main.h>


// Character bitmaps for Verdana 12pt
const uint8_t verdana_12ptBitmaps[] =
{
// @0 ' ' (2 pixels wide)
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //

// @15 '!' (2 pixels wide)
0x00, //
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0x00, //
0xC0, // ##
0xC0, // ##
0x00, //
0x00, //

// @30 '"' (5 pixels wide)
0xD8, // ## ##
0xD8, // ## ##
0xD8, // ## ##
0xD8, // ## ##
0xD8, // ## ##
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //

// @45 '#' (11 pixels wide)
0x00, 0x00, //
0x08, 0x40, // ##
0x08, 0x40, // ##
0x10, 0x80, //##
0x7F, 0xE0, //##########
0x7F, 0xE0, //##########
0x10, 0x80, //##
0x21, 0x00, // ##
0xFF, 0xC0, // ##########
0xFF, 0xC0, // ##########
0x21, 0x00, // ##
0x42, 0x00, //##
0x42, 0x00, //##
0x00, 0x00, //
0x00, 0x00, //

// @75 '$' (9 pixels wide)
0x08, 0x00, // #
0x08, 0x00, // #
0x3F, 0x00, // ######
0x69, 0x80, //## ###
0xC9, 0x80, // #####
0xC8, 0x00, // ###
0xC8, 0x00, // ###
0x7F, 0x00, //#######
0x09, 0x80, // ###
0x09, 0x80, // ###
0xC9, 0x80, // #####
0xCB, 0x00, // ### ##
0x7E, 0x00, //######
0x08, 0x00, // #
0x08, 0x00, // #

// @105 '%' (18 pixels wide)
0x00, 0x00, 0x00, //
0x7C, 0x10, 0x00, //##### #
0xC6, 0x10, 0x00, // ## ###
0xC6, 0x20, 0x00, // ## ## #
0xC6, 0x20, 0x00, // ## ## #
0xC6, 0x40, 0x00, // ## ###
0xC6, 0x4F, 0x80, // ## ########
0x7C, 0x98, 0xC0, //######## ##
0x00, 0x98, 0xC0, // ### ##
0x01, 0x18, 0xC0, //# ## ##
0x01, 0x18, 0xC0, //# ## ##
0x02, 0x18, 0xC0, // ### ##
0x02, 0x0F, 0x80, // # #####
0x00, 0x00, 0x00, //
0x00, 0x00, 0x00, //

// @150 '&' (12 pixels wide)
0x00, 0x00, //
0x3E, 0x00, // #####
0x63, 0x00, //## ##
0x63, 0x00, //## ##
0x63, 0x00, //## ##
0x36, 0x60, // ## ####
0x3C, 0x60, // #### ##
0x66, 0x60, //######
0xC3, 0x40, // #### #
0xC1, 0xC0, // ## ###
0xC0, 0xC0, // ####
0x61, 0x60, //### ##
0x3E, 0x30, // ##### ##
0x00, 0x00, //
0x00, 0x00, //

// @180 ''' (2 pixels wide)
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //

// @195 '(' (6 pixels wide)
0x0C, // ##
0x18, //##
0x30, // ##
0x60, //##
0x60, //##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0x60, //##
0x60, //##
0x30, // ##
0x18, //##

// @210 ')' (6 pixels wide)
0xC0, // ##
0x60, //##
0x30, // ##
0x18, //##
0x18, //##
0x0C, // ##
0x0C, // ##
0x0C, // ##
0x0C, // ##
0x0C, // ##
0x0C, // ##
0x18, //##
0x18, //##
0x30, // ##
0x60, //##

// @225 '*' (7 pixels wide)
0x10, //#
0x92, // ###
0x54, //# # #
0x38, // ###
0x38, // ###
0x54, //# # #
0x92, // ###
0x10, //#
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //

// @240 '+' (9 pixels wide)
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x08, 0x00, // #
0x08, 0x00, // #
0x08, 0x00, // #
0x08, 0x00, // #
0xFF, 0x80, // #########
0x08, 0x00, // #
0x08, 0x00, // #
0x08, 0x00, // #
0x08, 0x00, // #
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //

// @270 ',' (4 pixels wide)
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x70, //###
0x60, //##
0x60, //##
0x60, //##
0xC0, // ##

// @285 '-' (6 pixels wide)
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0xFC, // ######
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //

// @300 '.' (2 pixels wide)
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0xC0, // ##
0xC0, // ##
0xC0, // ##
0x00, //
0x00, //

// @315 '/' (9 pixels wide)
0x01, 0x80, //##
0x01, 0x80, //##
0x03, 0x00, // ##
0x03, 0x00, // ##
0x06, 0x00, //##
0x06, 0x00, //##
0x0C, 0x00, // ##
0x0C, 0x00, // ##
0x18, 0x00, //##
0x18, 0x00, //##
0x30, 0x00, // ##
0x30, 0x00, // ##
0x60, 0x00, //##
0x60, 0x00, //##
0xC0, 0x00, // ##

// @345 '0' (9 pixels wide)
0x00, 0x00, //
0x3E, 0x00, // #####
0x63, 0x00, //## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0x63, 0x00, //## ##
0x3E, 0x00, // #####
0x00, 0x00, //
0x00, 0x00, //

// @375 '1' (6 pixels wide)
0x00, //
0x30, // ##
0xF0, // ####
0x30, // ##
0x30, // ##
0x30, // ##
0x30, // ##
0x30, // ##
0x30, // ##
0x30, // ##
0x30, // ##
0x30, // ##
0xFC, // ######
0x00, //
0x00, //

// @390 '2' (9 pixels wide)
0x00, 0x00, //
0x7E, 0x00, //######
0xC3, 0x00, // ####
0xC1, 0x80, // ## ##
0x01, 0x80, //##
0x01, 0x80, //##
0x03, 0x00, // ##
0x06, 0x00, //##
0x0C, 0x00, // ##
0x18, 0x00, //##
0x30, 0x00, // ##
0x60, 0x00, //##
0xFF, 0x80, // #########
0x00, 0x00, //
0x00, 0x00, //

// @420 '3' (9 pixels wide)
0x00, 0x00, //
0x7E, 0x00, //######
0xC3, 0x00, // ####
0xC1, 0x80, // ## ##
0x01, 0x80, //##
0x03, 0x00, // ##
0x1E, 0x00, //####
0x03, 0x00, // ##
0x01, 0x80, //##
0x01, 0x80, //##
0xC1, 0x80, // ## ##
0xC3, 0x00, // ####
0x7E, 0x00, //######
0x00, 0x00, //
0x00, 0x00, //

// @450 '4' (10 pixels wide)
0x00, 0x00, //
0x03, 0x00, // ##
0x07, 0x00, //###
0x0B, 0x00, // # ##
0x13, 0x00, //###
0x23, 0x00, // # ##
0x43, 0x00, //###
0x83, 0x00, // # ##
0xFF, 0xC0, // ##########
0x03, 0x00, // ##
0x03, 0x00, // ##
0x03, 0x00, // ##
0x03, 0x00, // ##
0x00, 0x00, //
0x00, 0x00, //

// @480 '5' (9 pixels wide)
0x00, 0x00, //
0x7F, 0x80, //########
0x60, 0x00, //##
0x60, 0x00, //##
0x60, 0x00, //##
0x7E, 0x00, //######
0x03, 0x00, // ##
0x01, 0x80, //##
0x01, 0x80, //##
0x01, 0x80, //##
0xC1, 0x80, // ## ##
0xC3, 0x00, // ####
0x7E, 0x00, //######
0x00, 0x00, //
0x00, 0x00, //

// @510 '6' (9 pixels wide)
0x00, 0x00, //
0x0F, 0x00, // ####
0x38, 0x00, // ###
0x60, 0x00, //##
0x60, 0x00, //##
0xDE, 0x00, // ## ####
0xE3, 0x00, // ### ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0x63, 0x00, //## ##
0x3E, 0x00, // #####
0x00, 0x00, //
0x00, 0x00, //

// @540 '7' (9 pixels wide)
0x00, 0x00, //
0xFF, 0x80, // #########
0x01, 0x80, //##
0x03, 0x00, // ##
0x03, 0x00, // ##
0x06, 0x00, //##
0x06, 0x00, //##
0x0C, 0x00, // ##
0x0C, 0x00, // ##
0x18, 0x00, //##
0x18, 0x00, //##
0x30, 0x00, // ##
0x30, 0x00, // ##
0x00, 0x00, //
0x00, 0x00, //

// @570 '8' (9 pixels wide)
0x00, 0x00, //
0x3E, 0x00, // #####
0x63, 0x00, //## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0x63, 0x00, //## ##
0x3E, 0x00, // #####
0x63, 0x00, //## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0x63, 0x00, //## ##
0x3E, 0x00, // #####
0x00, 0x00, //
0x00, 0x00, //

// @600 '9' (9 pixels wide)
0x00, 0x00, //
0x3E, 0x00, // #####
0x63, 0x00, //## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0x63, 0x80, //## ###
0x3D, 0x80, // #### ##
0x01, 0x80, //##
0x03, 0x00, // ##
0x0E, 0x00, // ###
0x78, 0x00, //####
0x00, 0x00, //
0x00, 0x00, //

// @630 ':' (2 pixels wide)
0x00, //
0x00, //
0x00, //
0x00, //
0xC0, // ##
0xC0, // ##
0xC0, // ##
0x00, //
0x00, //
0x00, //
0xC0, // ##
0xC0, // ##
0xC0, // ##
0x00, //
0x00, //

// @645 ';' (4 pixels wide)
0x00, //
0x00, //
0x00, //
0x00, //
0x60, //##
0x60, //##
0x60, //##
0x00, //
0x00, //
0x00, //
0x70, //###
0x60, //##
0x60, //##
0x60, //##
0xC0, // ##

// @660 '<' (9 pixels wide)
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x80, // #
0x03, 0x00, // ##
0x0C, 0x00, // ##
0x30, 0x00, // ##
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0x30, 0x00, // ##
0x0C, 0x00, // ##
0x03, 0x00, // ##
0x00, 0x80, // #
0x00, 0x00, //
0x00, 0x00, //

// @690 '=' (9 pixels wide)
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0xFF, 0x80, // #########
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0xFF, 0x80, // #########
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //

// @720 '>' (9 pixels wide)
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x80, 0x00, // #
0x60, 0x00, //##
0x18, 0x00, //##
0x06, 0x00, //##
0x01, 0x80, //##
0x01, 0x80, //##
0x06, 0x00, //##
0x18, 0x00, //##
0x60, 0x00, //##
0x80, 0x00, // #
0x00, 0x00, //
0x00, 0x00, //

// @750 '?' (8 pixels wide)
0x00, //
0x7C, //#####
0xC6, // ## ##
0xC3, // ####
0x03, // ##
0x03, // ##
0x06, //##
0x0C, // ##
0x18, //##
0x18, //##
0x00, //
0x18, //##
0x18, //##
0x00, //
0x00, //

// @765 '@' (13 pixels wide)
0x00, 0x00, //
0x0F, 0x80, // #####
0x30, 0x60, // ## ##
0x40, 0x10, //# #
0x47, 0xD0, //# ##### #
0x8C, 0xC8, // # #####
0x98, 0xC8, // ### ###
0x98, 0xC8, // ### ###
0x98, 0xC8, // ### ###
0x98, 0xC8, // ### ###
0x99, 0xC8, // #######
0x4E, 0xF0, //#### ####
0x40, 0x00, //#
0x30, 0x00, // ##
0x0F, 0xC0, // ######

// @795 'A' (10 pixels wide)
0x00, 0x00, //
0x0C, 0x00, // ##
0x0C, 0x00, // ##
0x1E, 0x00, //####
0x1E, 0x00, //####
0x33, 0x00, // ####
0x33, 0x00, // ####
0x61, 0x80, //####
0x61, 0x80, //####
0x7F, 0x80, //########
0xC0, 0xC0, // ####
0xC0, 0xC0, // ####
0xC0, 0xC0, // ####
0x00, 0x00, //
0x00, 0x00, //

// @825 'B' (10 pixels wide)
0x00, 0x00, //
0xFE, 0x00, // #######
0xC3, 0x00, // ####
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x00, // ## #
0xFF, 0x00, // ########
0xC1, 0x80, // ## ##
0xC0, 0xC0, // ####
0xC0, 0xC0, // ####
0xC0, 0xC0, // ####
0xC1, 0x80, // ## ##
0xFF, 0x00, // ########
0x00, 0x00, //
0x00, 0x00, //

// @855 'C' (10 pixels wide)
0x00, 0x00, //
0x1F, 0x80, //######
0x70, 0xC0, //#####
0x60, 0xC0, //## ##
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0x60, 0xC0, //## ##
0x70, 0xC0, //#####
0x1F, 0x80, //######
0x00, 0x00, //
0x00, 0x00, //

// @885 'D' (11 pixels wide)
0x00, 0x00, //
0xFF, 0x00, // ########
0xC1, 0xC0, // ## ###
0xC0, 0xC0, // ####
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0xC0, 0xC0, // ####
0xC1, 0xC0, // ## ###
0xFF, 0x00, // ########
0x00, 0x00, //
0x00, 0x00, //

// @915 'E' (9 pixels wide)
0x00, 0x00, //
0xFF, 0x80, // #########
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xFF, 0x00, // ########
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xFF, 0x80, // #########
0x00, 0x00, //
0x00, 0x00, //

// @945 'F' (8 pixels wide)
0x00, //
0xFF, // ########
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xFF, // ########
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0x00, //
0x00, //

// @960 'G' (11 pixels wide)
0x00, 0x00, //
0x1F, 0xC0, //#######
0x70, 0x60, //### ##
0x60, 0x60, //####
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xC3, 0xE0, // #######
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0x60, 0x60, //####
0x70, 0x60, //### ##
0x1F, 0xC0, //#######
0x00, 0x00, //
0x00, 0x00, //

// @990 'H' (11 pixels wide)
0x00, 0x00, //
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0xFF, 0xE0, // ###########
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0x00, 0x00, //
0x00, 0x00, //

// @1020 'I' (6 pixels wide)
0x00, //
0xFC, // ######
0x30, // ##
0x30, // ##
0x30, // ##
0x30, // ##
0x30, // ##
0x30, // ##
0x30, // ##
0x30, // ##
0x30, // ##
0x30, // ##
0xFC, // ######
0x00, //
0x00, //

// @1035 'J' (7 pixels wide)
0x00, //
0x3E, // #####
0x06, //##
0x06, //##
0x06, //##
0x06, //##
0x06, //##
0x06, //##
0x06, //##
0x06, //##
0x06, //##
0x0C, // ##
0xF8, // #####
0x00, //
0x00, //

// @1050 'K' (10 pixels wide)
0x00, 0x00, //
0xC0, 0xC0, // ####
0xC1, 0x80, // ## ##
0xC3, 0x00, // ####
0xC6, 0x00, // ## ##
0xCC, 0x00, // ####
0xD8, 0x00, // ## ##
0xF8, 0x00, // #####
0xEC, 0x00, // ### ##
0xC6, 0x00, // ## ##
0xC3, 0x00, // ####
0xC1, 0x80, // ## ##
0xC0, 0xC0, // ####
0x00, 0x00, //
0x00, 0x00, //

// @1080 'L' (8 pixels wide)
0x00, //
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xFF, // ########
0x00, //
0x00, //

// @1095 'M' (13 pixels wide)
0x00, 0x00, //
0xC0, 0x38, // #####
0xE0, 0x38, // ### ###
0xE0, 0x78, // #######
0xB0, 0x58, // # ## # ##
0xB0, 0xD8, // # #### ##
0x98, 0x98, // ### ###
0x99, 0x98, // #######
0x8D, 0x18, // # ## # ##
0x8F, 0x18, // # #### ##
0x86, 0x18, // #####
0x86, 0x18, // #####
0x80, 0x18, // ###
0x00, 0x00, //
0x00, 0x00, //

// @1125 'N' (11 pixels wide)
0x00, 0x00, //
0xE0, 0x20, // ### #
0xE0, 0x20, // ### #
0xB0, 0x20, // # ###
0x98, 0x20, // ### #
0x8C, 0x20, // # ###
0x8C, 0x20, // # ###
0x86, 0x20, // ### #
0x83, 0x20, // # ###
0x83, 0x20, // # ###
0x81, 0xA0, // ### #
0x80, 0xE0, // # ###
0x80, 0xE0, // # ###
0x00, 0x00, //
0x00, 0x00, //

// @1155 'O' (12 pixels wide)
0x00, 0x00, //
0x1F, 0x80, //######
0x70, 0xE0, //######
0x60, 0x60, //####
0xC0, 0x30, // ####
0xC0, 0x30, // ####
0xC0, 0x30, // ####
0xC0, 0x30, // ####
0xC0, 0x30, // ####
0xC0, 0x30, // ####
0x60, 0x60, //####
0x70, 0xE0, //######
0x1F, 0x80, //######
0x00, 0x00, //
0x00, 0x00, //

// @1185 'P' (10 pixels wide)
0x00, 0x00, //
0xFF, 0x00, // ########
0xC1, 0x80, // ## ##
0xC0, 0xC0, // ####
0xC0, 0xC0, // ####
0xC0, 0xC0, // ####
0xC0, 0xC0, // ####
0xC1, 0x80, // ## ##
0xFF, 0x00, // ########
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0x00, 0x00, //
0x00, 0x00, //

// @1215 'Q' (12 pixels wide)
0x00, 0x00, //
0x1F, 0x80, //######
0x70, 0xE0, //######
0x60, 0x60, //####
0xC0, 0x30, // ####
0xC0, 0x30, // ####
0xC0, 0x30, // ####
0xC0, 0x30, // ####
0xC0, 0x30, // ####
0xC0, 0x30, // ####
0x60, 0x60, //####
0x70, 0xE0, //######
0x1F, 0x80, //######
0x03, 0x00, // ##
0x03, 0x80, // ###

// @1245 'R' (11 pixels wide)
0x00, 0x00, //
0xFF, 0x00, // ########
0xC1, 0x80, // ## ##
0xC0, 0xC0, // ####
0xC0, 0xC0, // ####
0xC0, 0xC0, // ####
0xC1, 0x80, // ## ##
0xFF, 0x00, // ########
0xC6, 0x00, // ## ##
0xC3, 0x00, // ####
0xC1, 0x80, // ## ##
0xC0, 0xC0, // ####
0xC0, 0x60, // ## ##
0x00, 0x00, //
0x00, 0x00, //

// @1275 'S' (9 pixels wide)
0x00, 0x00, //
0x3F, 0x00, // ######
0x61, 0x80, //####
0xC1, 0x80, // ## ##
0xC0, 0x00, // ##
0xE0, 0x00, // ###
0x7C, 0x00, //#####
0x1F, 0x00, //#####
0x03, 0x80, // ###
0x01, 0x80, //##
0xC1, 0x80, // ## ##
0xC3, 0x00, // ####
0x7E, 0x00, //######
0x00, 0x00, //
0x00, 0x00, //

// @1305 'T' (10 pixels wide)
0x00, 0x00, //
0xFF, 0xC0, // ##########
0x0C, 0x00, // ##
0x0C, 0x00, // ##
0x0C, 0x00, // ##
0x0C, 0x00, // ##
0x0C, 0x00, // ##
0x0C, 0x00, // ##
0x0C, 0x00, // ##
0x0C, 0x00, // ##
0x0C, 0x00, // ##
0x0C, 0x00, // ##
0x0C, 0x00, // ##
0x00, 0x00, //
0x00, 0x00, //

// @1335 'U' (11 pixels wide)
0x00, 0x00, //
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0xC0, 0x60, // ## ##
0x60, 0xC0, //## ##
0x3F, 0x80, // #######
0x00, 0x00, //
0x00, 0x00, //

// @1365 'V' (10 pixels wide)
0x00, 0x00, //
0xC0, 0xC0, // ####
0xC0, 0xC0, // ####
0xC0, 0xC0, // ####
0x61, 0x80, //####
0x61, 0x80, //####
0x33, 0x00, // ####
0x33, 0x00, // ####
0x33, 0x00, // ####
0x1E, 0x00, //####
0x1E, 0x00, //####
0x0C, 0x00, // ##
0x0C, 0x00, // ##
0x00, 0x00, //
0x00, 0x00, //

// @1395 'W' (16 pixels wide)
0x00, 0x00, //
0xC1, 0x83, // ## ## ##
0xC1, 0x83, // ## ## ##
0xC1, 0x83, // ## ## ##
0x63, 0xC6, //## #### ##
0x62, 0x46, //## ## ##
0x66, 0x66, //########
0x36, 0x6C, // ## #### ##
0x34, 0x2C, // ## ## ##
0x3C, 0x3C, // ########
0x1C, 0x38, //######
0x18, 0x18, //####
0x18, 0x18, //####
0x00, 0x00, //
0x00, 0x00, //

// @1425 'X' (10 pixels wide)
0x00, 0x00, //
0xC0, 0xC0, // ####
0xC0, 0xC0, // ####
0x61, 0x80, //####
0x33, 0x00, // ####
0x33, 0x00, // ####
0x1E, 0x00, //####
0x1E, 0x00, //####
0x33, 0x00, // ####
0x33, 0x00, // ####
0x61, 0x80, //####
0xC0, 0xC0, // ####
0xC0, 0xC0, // ####
0x00, 0x00, //
0x00, 0x00, //

// @1455 'Y' (10 pixels wide)
0x00, 0x00, //
0xC0, 0xC0, // ####
0xC0, 0xC0, // ####
0x61, 0x80, //####
0x61, 0x80, //####
0x33, 0x00, // ####
0x33, 0x00, // ####
0x1E, 0x00, //####
0x0C, 0x00, // ##
0x0C, 0x00, // ##
0x0C, 0x00, // ##
0x0C, 0x00, // ##
0x0C, 0x00, // ##
0x00, 0x00, //
0x00, 0x00, //

// @1485 'Z' (9 pixels wide)
0x00, 0x00, //
0xFF, 0x80, // #########
0x01, 0x80, //##
0x03, 0x00, // ##
0x06, 0x00, //##
0x06, 0x00, //##
0x0C, 0x00, // ##
0x18, 0x00, //##
0x30, 0x00, // ##
0x30, 0x00, // ##
0x60, 0x00, //##
0xC0, 0x00, // ##
0xFF, 0x80, // #########
0x00, 0x00, //
0x00, 0x00, //

// @1515 '[' (5 pixels wide)
0xF8, // #####
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##

// @1530 '\' (9 pixels wide)
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0x60, 0x00, //##
0x60, 0x00, //##
0x30, 0x00, // ##
0x30, 0x00, // ##
0x18, 0x00, //##
0x18, 0x00, //##
0x0C, 0x00, // ##
0x0C, 0x00, // ##
0x06, 0x00, //##
0x06, 0x00, //##
0x03, 0x00, // ##
0x03, 0x00, // ##
0x01, 0x80, //##

// @1560 ']' (5 pixels wide)
0xF8, // #####
0x18, //##
0x18, //##
0x18, //##
0x18, //##
0x18, //##
0x18, //##
0x18, //##
0x18, //##
0x18, //##
0x18, //##
0x18, //##
0x18, //##
0x18, //##
0x18, //##

// @1575 '^' (11 pixels wide)
0x00, 0x00, //
0x04, 0x00, //#
0x0E, 0x00, // ###
0x1B, 0x00, //## ##
0x31, 0x80, // ## ##
0x60, 0xC0, //## ##
0xC0, 0x60, // ## ##
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //

// @1605 '_' (11 pixels wide)
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0xFF, 0xE0, // ###########

// @1635 '`' (3 pixels wide)
0x00, //
0xC0, // ##
0x60, //##
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //
0x00, //

// @1650 'a' (9 pixels wide)
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x3E, 0x00, // #####
0x63, 0x00, //## ##
0x01, 0x80, //##
0x1F, 0x80, //######
0x61, 0x80, //####
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC3, 0x80, // #####
0x7D, 0x80, //##### ##
0x00, 0x00, //
0x00, 0x00, //

// @1680 'b' (9 pixels wide)
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xDE, 0x00, // ## ####
0xE3, 0x00, // ### ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xE3, 0x00, // ### ##
0xDE, 0x00, // ## ####
0x00, 0x00, //
0x00, 0x00, //

// @1710 'c' (8 pixels wide)
0x00, //
0x00, //
0x00, //
0x00, //
0x3E, // #####
0x63, //## ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0x63, //## ##
0x3E, // #####
0x00, //
0x00, //

// @1725 'd' (9 pixels wide)
0x01, 0x80, //##
0x01, 0x80, //##
0x01, 0x80, //##
0x01, 0x80, //##
0x3D, 0x80, // #### ##
0x63, 0x80, //## ###
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0x63, 0x80, //## ###
0x3D, 0x80, // #### ##
0x00, 0x00, //
0x00, 0x00, //

// @1755 'e' (9 pixels wide)
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x3E, 0x00, // #####
0x63, 0x00, //## ##
0xC1, 0x80, // ## ##
0xFF, 0x80, // #########
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0x61, 0x80, //####
0x3F, 0x00, // ######
0x00, 0x00, //
0x00, 0x00, //

// @1785 'f' (6 pixels wide)
0x3C, // ####
0x60, //##
0x60, //##
0x60, //##
0xF8, // #####
0x60, //##
0x60, //##
0x60, //##
0x60, //##
0x60, //##
0x60, //##
0x60, //##
0x60, //##
0x00, //
0x00, //

// @1800 'g' (9 pixels wide)
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x3D, 0x80, // #### ##
0x63, 0x80, //## ###
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0x63, 0x80, //## ###
0x3D, 0x80, // #### ##
0x01, 0x80, //##
0x63, 0x00, //## ##

// @1830 'h' (9 pixels wide)
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xDE, 0x00, // ## ####
0xE3, 0x00, // ### ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0x00, 0x00, //
0x00, 0x00, //

// @1860 'i' (2 pixels wide)
0xC0, // ##
0xC0, // ##
0x00, //
0x00, //
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0x00, //
0x00, //

// @1875 'j' (4 pixels wide)
0x30, // ##
0x30, // ##
0x00, //
0x00, //
0xF0, // ####
0x30, // ##
0x30, // ##
0x30, // ##
0x30, // ##
0x30, // ##
0x30, // ##
0x30, // ##
0x30, // ##
0x30, // ##
0x30, // ##

// @1890 'k' (9 pixels wide)
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xC0, 0x00, // ##
0xC3, 0x00, // ####
0xC6, 0x00, // ## ##
0xCC, 0x00, // ####
0xD8, 0x00, // ## ##
0xF8, 0x00, // #####
0xEC, 0x00, // ### ##
0xC6, 0x00, // ## ##
0xC3, 0x00, // ####
0xC1, 0x80, // ## ##
0x00, 0x00, //
0x00, 0x00, //

// @1920 'l' (2 pixels wide)
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0x00, //
0x00, //

// @1935 'm' (14 pixels wide)
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0xDE, 0x78, // ## ########
0xE3, 0x8C, // ### ### ##
0xC3, 0x0C, // ######
0xC3, 0x0C, // ######
0xC3, 0x0C, // ######
0xC3, 0x0C, // ######
0xC3, 0x0C, // ######
0xC3, 0x0C, // ######
0xC3, 0x0C, // ######
0x00, 0x00, //
0x00, 0x00, //

// @1965 'n' (9 pixels wide)
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0xDE, 0x00, // ## ####
0xE3, 0x00, // ### ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0x00, 0x00, //
0x00, 0x00, //

// @1995 'o' (9 pixels wide)
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x3E, 0x00, // #####
0x63, 0x00, //## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0x63, 0x00, //## ##
0x3E, 0x00, // #####
0x00, 0x00, //
0x00, 0x00, //

// @2025 'p' (9 pixels wide)
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0xDE, 0x00, // ## ####
0xE3, 0x00, // ### ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xE3, 0x00, // ### ##
0xDE, 0x00, // ## ####
0xC0, 0x00, // ##
0xC0, 0x00, // ##

// @2055 'q' (9 pixels wide)
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x3D, 0x80, // #### ##
0x63, 0x80, //## ###
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0x63, 0x80, //## ###
0x3D, 0x80, // #### ##
0x01, 0x80, //##
0x01, 0x80, //##

// @2085 'r' (7 pixels wide)
0x00, //
0x00, //
0x00, //
0x00, //
0xCE, // #####
0xDE, // ## ####
0xE0, // ###
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0x00, //
0x00, //

// @2100 's' (7 pixels wide)
0x00, //
0x00, //
0x00, //
0x00, //
0x7C, //#####
0xC6, // ## ##
0xC0, // ##
0xF0, // ####
0x7C, //#####
0x1E, //####
0x06, //##
0xC6, // ## ##
0x7C, //#####
0x00, //
0x00, //

// @2115 't' (6 pixels wide)
0x00, //
0x00, //
0x60, //##
0x60, //##
0xFC, // ######
0x60, //##
0x60, //##
0x60, //##
0x60, //##
0x60, //##
0x60, //##
0x60, //##
0x3C, // ####
0x00, //
0x00, //

// @2130 'u' (9 pixels wide)
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0xC1, 0x80, // ## ##
0x63, 0x80, //## ###
0x3D, 0x80, // #### ##
0x00, 0x00, //
0x00, 0x00, //

// @2160 'v' (10 pixels wide)
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0xC0, 0xC0, // ####
0xC0, 0xC0, // ####
0x61, 0x80, //####
0x61, 0x80, //####
0x33, 0x00, // ####
0x33, 0x00, // ####
0x1E, 0x00, //####
0x1E, 0x00, //####
0x0C, 0x00, // ##
0x00, 0x00, //
0x00, 0x00, //

// @2190 'w' (14 pixels wide)
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0xC3, 0x0C, // ######
0xC3, 0x0C, // ######
0x63, 0x18, //## ## ##
0x67, 0x98, //########
0x64, 0x98, //######
0x3C, 0xF0, // ########
0x3C, 0xF0, // ########
0x18, 0x60, //####
0x18, 0x60, //####
0x00, 0x00, //
0x00, 0x00, //

// @2220 'x' (9 pixels wide)
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0xC1, 0x80, // ## ##
0x63, 0x00, //## ##
0x63, 0x00, //## ##
0x36, 0x00, // ## ##
0x1C, 0x00, //###
0x36, 0x00, // ## ##
0x63, 0x00, //## ##
0x63, 0x00, //## ##
0xC1, 0x80, // ## ##
0x00, 0x00, //
0x00, 0x00, //

// @2250 'y' (10 pixels wide)
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0xC0, 0xC0, // ####
0xC0, 0xC0, // ####
0x61, 0x80, //####
0x61, 0x80, //####
0x33, 0x00, // ####
0x33, 0x00, // ####
0x1E, 0x00, //####
0x1E, 0x00, //####
0x0C, 0x00, // ##
0x0C, 0x00, // ##
0x18, 0x00, //##

// @2280 'z' (8 pixels wide)
0x00, //
0x00, //
0x00, //
0x00, //
0xFF, // ########
0x03, // ##
0x06, //##
0x0C, // ##
0x18, //##
0x30, // ##
0x60, //##
0xC0, // ##
0xFF, // ########
0x00, //
0x00, //

// @2295 '{' (8 pixels wide)
0x0F, // ####
0x18, //##
0x18, //##
0x18, //##
0x18, //##
0x18, //##
0x30, // ##
0xE0, // ###
0x30, // ##
0x18, //##
0x18, //##
0x18, //##
0x18, //##
0x18, //##
0x18, //##

// @2310 '|' (2 pixels wide)
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##
0xC0, // ##

// @2325 '}' (8 pixels wide)
0xF0, // ####
0x18, //##
0x18, //##
0x18, //##
0x18, //##
0x18, //##
0x0C, // ##
0x07, //###
0x0C, // ##
0x18, //##
0x18, //##
0x18, //##
0x18, //##
0x18, //##
0x18, //##

// @2340 '~' (11 pixels wide)
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x30, 0x20, // ###
0x48, 0x20, //## #
0x84, 0x20, // ###
0x82, 0x40, // # ##
0x81, 0x80, // ###
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
0x00, 0x00, //
};

// Character descriptors for Verdana 12pt
// { [Char width in bits], [Char height in bits], [Offset into verdana_12ptCharBitmaps in bytes] }
const FONT_CHAR_INFO verdana_12ptDescriptors[] =
{
{ 2, 15, 0 }, 		//
{ 2, 15, 15 }, 		// !
{ 5, 15, 30 }, 		// "
{ 11, 15, 45 }, 		// #
{ 9, 15, 75 }, 		// $
{ 18, 15, 105 }, 		// %
{ 12, 15, 150 }, 		// &
{ 2, 15, 180 }, 		// '
{ 6, 15, 195 }, 		// (
{ 6, 15, 210 }, 		// )
{ 7, 15, 225 }, 		// *
{ 9, 15, 240 }, 		// +
{ 4, 15, 270 }, 		// ,
{ 6, 15, 285 }, 		// -
{ 2, 15, 300 }, 		// .
{ 9, 15, 315 }, 		// /
{ 9, 15, 345 }, 		// 0
{ 6, 15, 375 }, 		// 1
{ 9, 15, 390 }, 		// 2
{ 9, 15, 420 }, 		// 3
{ 10, 15, 450 }, 		// 4
{ 9, 15, 480 }, 		// 5
{ 9, 15, 510 }, 		// 6
{ 9, 15, 540 }, 		// 7
{ 9, 15, 570 }, 		// 8
{ 9, 15, 600 }, 		// 9
{ 2, 15, 630 }, 		// :
{ 4, 15, 645 }, 		// ;
{ 9, 15, 660 }, 		// <
{ 9, 15, 690 }, 		// =
{ 9, 15, 720 }, 		// >
{ 8, 15, 750 }, 		// ?
{ 13, 15, 765 }, 		// @
{ 10, 15, 795 }, 		// A
{ 10, 15, 825 }, 		// B
{ 10, 15, 855 }, 		// C
{ 11, 15, 885 }, 		// D
{ 9, 15, 915 }, 		// E
{ 8, 15, 945 }, 		// F
{ 11, 15, 960 }, 		// G
{ 11, 15, 990 }, 		// H
{ 6, 15, 1020 }, 		// I
{ 7, 15, 1035 }, 		// J
{ 10, 15, 1050 }, 		// K
{ 8, 15, 1080 }, 		// L
{ 13, 15, 1095 }, 		// M
{ 11, 15, 1125 }, 		// N
{ 12, 15, 1155 }, 		// O
{ 10, 15, 1185 }, 		// P
{ 12, 15, 1215 }, 		// Q
{ 11, 15, 1245 }, 		// R
{ 9, 15, 1275 }, 		// S
{ 10, 15, 1305 }, 		// T
{ 11, 15, 1335 }, 		// U
{ 10, 15, 1365 }, 		// V
{ 16, 15, 1395 }, 		// W
{ 10, 15, 1425 }, 		// X
{ 10, 15, 1455 }, 		// Y
{ 9, 15, 1485 }, 		// Z
{ 5, 15, 1515 }, 		// [
{ 9, 15, 1530 }, 		// Backslash
{ 5, 15, 1560 }, 		// ]
{ 11, 15, 1575 }, 		// ^
{ 11, 15, 1605 }, 		// _
{ 3, 15, 1635 }, 		// `
{ 9, 15, 1650 }, 		// a
{ 9, 15, 1680 }, 		// b
{ 8, 15, 1710 }, 		// c
{ 9, 15, 1725 }, 		// d
{ 9, 15, 1755 }, 		// e
{ 6, 15, 1785 }, 		// f
{ 9, 15, 1800 }, 		// g
{ 9, 15, 1830 }, 		// h
{ 2, 15, 1860 }, 		// i
{ 4, 15, 1875 }, 		// j
{ 9, 15, 1890 }, 		// k
{ 2, 15, 1920 }, 		// l
{ 14, 15, 1935 }, 		// m
{ 9, 15, 1965 }, 		// n
{ 9, 15, 1995 }, 		// o
{ 9, 15, 2025 }, 		// p
{ 9, 15, 2055 }, 		// q
{ 7, 15, 2085 }, 		// r
{ 7, 15, 2100 }, 		// s
{ 6, 15, 2115 }, 		// t
{ 9, 15, 2130 }, 		// u
{ 10, 15, 2160 }, 		// v
{ 14, 15, 2190 }, 		// w
{ 9, 15, 2220 }, 		// x
{ 10, 15, 2250 }, 		// y
{ 8, 15, 2280 }, 		// z
{ 8, 15, 2295 }, 		// {
{ 2, 15, 2310 }, 		// |
{ 8, 15, 2325 }, 		// }
{ 11, 15, 2340 }, 		// ~
};

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wdiscarded-qualifiers"
// Font information for Verdana 12pt
FONT_INFO verdana_12ptFontInfo =
{
' ', //Start character
'~', //End character
verdana_12ptDescriptors, //Character descriptor array
verdana_12ptBitmaps, //Character bitmap array
};
#pragma GCC diagnostic pop
