// 
//  Font data for Lucida Console 14pt
// 

#include <main.h>

// Character bitmaps for Lucida Console 14pt
const uint8_t lucidaConsole_14ptBitmaps[] =
{
	// @0 ' ' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @38 '!' (11 pixels wide)
	0x00, 0x00, //            
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @76 '"' (11 pixels wide)
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @114 '#' (11 pixels wide)
	0x00, 0x00, //            
	0x08, 0x80, //     #   #  
	0x08, 0x80, //     #   #  
	0x08, 0x80, //     #   #  
	0x11, 0x00, //    #   #   
	0x11, 0x00, //    #   #   
	0x7F, 0xE0, //  ##########
	0x11, 0x00, //    #   #   
	0x12, 0x00, //    #  #    
	0x22, 0x00, //   #   #    
	0xFF, 0xC0, // ########## 
	0x22, 0x00, //   #   #    
	0x22, 0x00, //   #   #    
	0x44, 0x00, //  #   #     
	0x44, 0x00, //  #   #     
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @152 '$' (11 pixels wide)
	0x04, 0x00, //      #     
	0x1F, 0x00, //    #####   
	0x3F, 0x80, //   #######  
	0x64, 0x00, //  ##  #     
	0x64, 0x00, //  ##  #     
	0x64, 0x00, //  ##  #     
	0x3C, 0x00, //   ####     
	0x1C, 0x00, //    ###     
	0x07, 0x00, //      ###   
	0x07, 0x00, //      ###   
	0x05, 0x80, //      # ##  
	0x05, 0x80, //      # ##  
	0x45, 0x80, //  #   # ##  
	0x7F, 0x00, //  #######   
	0x3E, 0x00, //   #####    
	0x04, 0x00, //      #     
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @190 '%' (11 pixels wide)
	0x00, 0x00, //            
	0x78, 0x20, //  ####     #
	0xCC, 0x40, // ##  ##   # 
	0xCC, 0x80, // ##  ##  #  
	0xCD, 0x80, // ##  ## ##  
	0xCD, 0x00, // ##  ## #   
	0x7A, 0x00, //  #### #    
	0x04, 0x00, //      #     
	0x04, 0x00, //      #     
	0x0B, 0xC0, //     # #### 
	0x16, 0x60, //    # ##  ##
	0x36, 0x60, //   ## ##  ##
	0x26, 0x60, //   #  ##  ##
	0x46, 0x60, //  #   ##  ##
	0x83, 0xC0, // #     #### 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @228 '&' (11 pixels wide)
	0x00, 0x00, //            
	0x1E, 0x00, //    ####    
	0x3F, 0x00, //   ######   
	0x33, 0x00, //   ##  ##   
	0x33, 0x00, //   ##  ##   
	0x36, 0x00, //   ## ##    
	0x1C, 0x00, //    ###     
	0x38, 0x00, //   ###      
	0x6C, 0x60, //  ## ##   ##
	0xCE, 0x60, // ##  ###  ##
	0xC6, 0x60, // ##   ##  ##
	0xC3, 0xC0, // ##    #### 
	0xE3, 0xC0, // ###   #### 
	0x7F, 0xC0, //  ######### 
	0x3E, 0xE0, //   ##### ###
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @266 ''' (11 pixels wide)
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @304 '(' (11 pixels wide)
	0x00, 0xC0, //         ## 
	0x03, 0xC0, //       #### 
	0x07, 0x00, //      ###   
	0x06, 0x00, //      ##    
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x06, 0x00, //      ##    
	0x07, 0x00, //      ###   
	0x03, 0xC0, //       #### 
	0x00, 0xC0, //         ## 
	0x00, 0x00, //            

	// @342 ')' (11 pixels wide)
	0x60, 0x00, //  ##        
	0x78, 0x00, //  ####      
	0x1C, 0x00, //    ###     
	0x0C, 0x00, //     ##     
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x0C, 0x00, //     ##     
	0x1C, 0x00, //    ###     
	0x78, 0x00, //  ####      
	0x60, 0x00, //  ##        
	0x00, 0x00, //            

	// @380 '*' (11 pixels wide)
	0x00, 0x00, //            
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x6D, 0x80, //  ## ## ##  
	0x73, 0x80, //  ###  ###  
	0x00, 0x00, //            
	0x1E, 0x00, //    ####    
	0x33, 0x00, //   ##  ##   
	0x12, 0x00, //    #  #    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @418 '+' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x7F, 0xE0, //  ##########
	0x7F, 0xE0, //  ##########
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @456 ',' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x06, 0x00, //      ##    
	0x04, 0x00, //      #     
	0x0C, 0x00, //     ##     
	0x00, 0x00, //            

	// @494 '-' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x3F, 0x80, //   #######  
	0x3F, 0x80, //   #######  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @532 '.' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @570 '/' (11 pixels wide)
	0x00, 0xC0, //         ## 
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x60, 0x00, //  ##        
	0x00, 0x00, //            

	// @608 '0' (11 pixels wide)
	0x00, 0x00, //            
	0x0E, 0x00, //     ###    
	0x1F, 0x80, //    ######  
	0x31, 0x80, //   ##   ##  
	0x71, 0xC0, //  ###   ### 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x71, 0xC0, //  ###   ### 
	0x31, 0x80, //   ##   ##  
	0x1F, 0x00, //    #####   
	0x0E, 0x00, //     ###    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @646 '1' (11 pixels wide)
	0x00, 0x00, //            
	0x06, 0x00, //      ##    
	0x3E, 0x00, //   #####    
	0x66, 0x00, //  ##  ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x7F, 0xE0, //  ##########
	0x7F, 0xE0, //  ##########
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @684 '2' (11 pixels wide)
	0x00, 0x00, //            
	0x1F, 0x00, //    #####   
	0x3F, 0x80, //   #######  
	0x21, 0xC0, //   #    ### 
	0x00, 0xC0, //         ## 
	0x00, 0xC0, //         ## 
	0x00, 0xC0, //         ## 
	0x01, 0x80, //        ##  
	0x03, 0x00, //       ##   
	0x06, 0x00, //      ##    
	0x0C, 0x00, //     ##     
	0x18, 0x00, //    ##      
	0x30, 0x00, //   ##       
	0x3F, 0xC0, //   ######## 
	0x3F, 0xC0, //   ######## 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @722 '3' (11 pixels wide)
	0x00, 0x00, //            
	0x1F, 0x00, //    #####   
	0x3F, 0x80, //   #######  
	0x21, 0x80, //   #    ##  
	0x01, 0x80, //        ##  
	0x03, 0x00, //       ##   
	0x1E, 0x00, //    ####    
	0x1F, 0x00, //    #####   
	0x03, 0x00, //       ##   
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x03, 0x80, //       ###  
	0x3F, 0x00, //   ######   
	0x3E, 0x00, //   #####    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @760 '4' (11 pixels wide)
	0x00, 0x00, //            
	0x03, 0x00, //       ##   
	0x07, 0x00, //      ###   
	0x0F, 0x00, //     ####   
	0x0B, 0x00, //     # ##   
	0x13, 0x00, //    #  ##   
	0x33, 0x00, //   ##  ##   
	0x63, 0x00, //  ##   ##   
	0x43, 0x00, //  #    ##   
	0xFF, 0xC0, // ########## 
	0xFF, 0xC0, // ########## 
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @798 '5' (11 pixels wide)
	0x00, 0x00, //            
	0x3F, 0x80, //   #######  
	0x3F, 0x80, //   #######  
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x3E, 0x00, //   #####    
	0x3F, 0x00, //   ######   
	0x03, 0x80, //       ###  
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x03, 0x80, //       ###  
	0x3F, 0x00, //   ######   
	0x3E, 0x00, //   #####    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @836 '6' (11 pixels wide)
	0x00, 0x00, //            
	0x0F, 0x00, //     ####   
	0x1F, 0x80, //    ######  
	0x38, 0x00, //   ###      
	0x30, 0x00, //   ##       
	0x60, 0x00, //  ##        
	0x67, 0x00, //  ##  ###   
	0x6F, 0x80, //  ## #####  
	0x71, 0xC0, //  ###   ### 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x31, 0xC0, //   ##   ### 
	0x3F, 0x80, //   #######  
	0x0F, 0x00, //     ####   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @874 '7' (11 pixels wide)
	0x00, 0x00, //            
	0x7F, 0x80, //  ########  
	0x7F, 0x80, //  ########  
	0x01, 0x80, //        ##  
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @912 '8' (11 pixels wide)
	0x00, 0x00, //            
	0x0F, 0x00, //     ####   
	0x3F, 0x80, //   #######  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x39, 0x80, //   ###  ##  
	0x1F, 0x00, //    #####   
	0x0E, 0x00, //     ###    
	0x37, 0x80, //   ## ####  
	0x61, 0xC0, //  ##    ### 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x71, 0xC0, //  ###   ### 
	0x3F, 0x80, //   #######  
	0x1F, 0x00, //    #####   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @950 '9' (11 pixels wide)
	0x00, 0x00, //            
	0x1E, 0x00, //    ####    
	0x3F, 0x80, //   #######  
	0x71, 0x80, //  ###   ##  
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x71, 0xC0, //  ###   ### 
	0x3E, 0xC0, //   ##### ## 
	0x1C, 0xC0, //    ###  ## 
	0x00, 0xC0, //         ## 
	0x01, 0x80, //        ##  
	0x03, 0x80, //       ###  
	0x3F, 0x00, //   ######   
	0x1E, 0x00, //    ####    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @988 ':' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1026 ';' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x06, 0x00, //      ##    
	0x04, 0x00, //      #     
	0x0C, 0x00, //     ##     
	0x00, 0x00, //            

	// @1064 '<' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x40, //          # 
	0x01, 0xC0, //        ### 
	0x07, 0x80, //      ####  
	0x0E, 0x00, //     ###    
	0x38, 0x00, //   ###      
	0x38, 0x00, //   ###      
	0x0E, 0x00, //     ###    
	0x07, 0x80, //      ####  
	0x01, 0xC0, //        ### 
	0x00, 0x40, //          # 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1102 '=' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7F, 0xC0, //  ######### 
	0x7F, 0xC0, //  ######### 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7F, 0xC0, //  ######### 
	0x7F, 0xC0, //  ######### 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1140 '>' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x40, 0x00, //  #         
	0x70, 0x00, //  ###       
	0x3C, 0x00, //   ####     
	0x0E, 0x00, //     ###    
	0x03, 0x80, //       ###  
	0x03, 0x80, //       ###  
	0x0E, 0x00, //     ###    
	0x3C, 0x00, //   ####     
	0x70, 0x00, //  ###       
	0x40, 0x00, //  #         
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1178 '?' (11 pixels wide)
	0x00, 0x00, //            
	0x7F, 0x00, //  #######   
	0x7F, 0xC0, //  ######### 
	0x41, 0xC0, //  #     ### 
	0x00, 0xC0, //         ## 
	0x00, 0xC0, //         ## 
	0x01, 0x80, //        ##  
	0x03, 0x00, //       ##   
	0x06, 0x00, //      ##    
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1216 '@' (11 pixels wide)
	0x00, 0x00, //            
	0x0F, 0x00, //     ####   
	0x31, 0x80, //   ##   ##  
	0x60, 0xC0, //  ##     ## 
	0x63, 0xC0, //  ##   #### 
	0xC6, 0xC0, // ##   ## ## 
	0xCC, 0xC0, // ##  ##  ## 
	0xCC, 0xC0, // ##  ##  ## 
	0xCD, 0xC0, // ##  ## ### 
	0xCD, 0xC0, // ##  ## ### 
	0xCE, 0xC0, // ##  ### ## 
	0x66, 0xE0, //  ##  ## ###
	0x60, 0x00, //  ##        
	0x30, 0x80, //   ##    #  
	0x0F, 0x80, //     #####  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1254 'A' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x0A, 0x00, //     # #    
	0x1B, 0x00, //    ## ##   
	0x13, 0x00, //    #  ##   
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x3F, 0x80, //   #######  
	0x7F, 0xC0, //  ######### 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0xC0, 0x60, // ##       ##
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1292 'B' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7F, 0x00, //  #######   
	0x7F, 0xC0, //  ######### 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x61, 0xC0, //  ##    ### 
	0x7F, 0x00, //  #######   
	0x7F, 0x80, //  ########  
	0x61, 0xC0, //  ##    ### 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x7F, 0xC0, //  ######### 
	0x7F, 0x00, //  #######   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1330 'C' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x07, 0xC0, //      ##### 
	0x1F, 0xE0, //    ########
	0x38, 0x20, //   ###     #
	0x70, 0x00, //  ###       
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x70, 0x00, //  ###       
	0x38, 0x00, //   ###      
	0x1F, 0xE0, //    ########
	0x07, 0xC0, //      ##### 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1368 'D' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7F, 0x00, //  #######   
	0x7F, 0xC0, //  ######### 
	0x61, 0xC0, //  ##    ### 
	0x60, 0xE0, //  ##     ###
	0x60, 0x60, //  ##      ##
	0x60, 0x60, //  ##      ##
	0x60, 0x60, //  ##      ##
	0x60, 0x60, //  ##      ##
	0x60, 0xE0, //  ##     ###
	0x61, 0xC0, //  ##    ### 
	0x7F, 0x80, //  ########  
	0x7F, 0x00, //  #######   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1406 'E' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x3F, 0xC0, //   ######## 
	0x3F, 0xC0, //   ######## 
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x3F, 0x80, //   #######  
	0x3F, 0x80, //   #######  
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x3F, 0xC0, //   ######## 
	0x3F, 0xC0, //   ######## 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1444 'F' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x3F, 0xC0, //   ######## 
	0x3F, 0xC0, //   ######## 
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x3F, 0x80, //   #######  
	0x3F, 0x80, //   #######  
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1482 'G' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x0F, 0x80, //     #####  
	0x3F, 0xC0, //   ######## 
	0x70, 0x40, //  ###     # 
	0xE0, 0x00, // ###        
	0xC0, 0x00, // ##         
	0xC3, 0xC0, // ##    #### 
	0xC3, 0xC0, // ##    #### 
	0xC0, 0xC0, // ##      ## 
	0xE0, 0xC0, // ###     ## 
	0x70, 0xC0, //  ###    ## 
	0x3F, 0xC0, //   ######## 
	0x0F, 0x80, //     #####  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1520 'H' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x7F, 0xC0, //  ######### 
	0x7F, 0xC0, //  ######### 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1558 'I' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7F, 0x80, //  ########  
	0x7F, 0x80, //  ########  
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x7F, 0x80, //  ########  
	0x7F, 0x80, //  ########  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1596 'J' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1F, 0x80, //    ######  
	0x1F, 0x80, //    ######  
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x03, 0x80, //       ###  
	0x3F, 0x00, //   ######   
	0x3E, 0x00, //   #####    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1634 'K' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x61, 0xC0, //  ##    ### 
	0x63, 0x80, //  ##   ###  
	0x63, 0x00, //  ##   ##   
	0x66, 0x00, //  ##  ##    
	0x6C, 0x00, //  ## ##     
	0x78, 0x00, //  ####      
	0x6C, 0x00, //  ## ##     
	0x6E, 0x00, //  ## ###    
	0x67, 0x00, //  ##  ###   
	0x63, 0x80, //  ##   ###  
	0x61, 0xC0, //  ##    ### 
	0x60, 0xE0, //  ##     ###
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1672 'L' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x3F, 0xC0, //   ######## 
	0x3F, 0xC0, //   ######## 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1710 'M' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0xE1, 0xC0, // ###    ### 
	0xE1, 0xC0, // ###    ### 
	0xF1, 0xC0, // ####   ### 
	0xD2, 0xC0, // ## #  # ## 
	0xD2, 0xC0, // ## #  # ## 
	0xDA, 0xC0, // ## ## # ## 
	0xCC, 0xC0, // ##  ##  ## 
	0xCC, 0xC0, // ##  ##  ## 
	0xCC, 0xC0, // ##  ##  ## 
	0xC0, 0xC0, // ##      ## 
	0xC0, 0xC0, // ##      ## 
	0xC0, 0xC0, // ##      ## 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1748 'N' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x60, 0xC0, //  ##     ## 
	0x70, 0xC0, //  ###    ## 
	0x78, 0xC0, //  ####   ## 
	0x78, 0xC0, //  ####   ## 
	0x7C, 0xC0, //  #####  ## 
	0x6C, 0xC0, //  ## ##  ## 
	0x66, 0xC0, //  ##  ## ## 
	0x67, 0xC0, //  ##  ##### 
	0x63, 0xC0, //  ##   #### 
	0x63, 0xC0, //  ##   #### 
	0x61, 0xC0, //  ##    ### 
	0x60, 0xC0, //  ##     ## 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1786 'O' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1E, 0x00, //    ####    
	0x7F, 0x80, //  ########  
	0x61, 0x80, //  ##    ##  
	0xC0, 0xC0, // ##      ## 
	0xC0, 0xC0, // ##      ## 
	0xC0, 0xC0, // ##      ## 
	0xC0, 0xC0, // ##      ## 
	0xC0, 0xC0, // ##      ## 
	0xC0, 0xC0, // ##      ## 
	0x61, 0x80, //  ##    ##  
	0x7F, 0x80, //  ########  
	0x1E, 0x00, //    ####    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1824 'P' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7F, 0x00, //  #######   
	0x7F, 0xC0, //  ######### 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x61, 0xC0, //  ##    ### 
	0x7F, 0x80, //  ########  
	0x7F, 0x00, //  #######   
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1862 'Q' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1E, 0x00, //    ####    
	0x7F, 0x80, //  ########  
	0x61, 0x80, //  ##    ##  
	0xC0, 0xC0, // ##      ## 
	0xC0, 0xC0, // ##      ## 
	0xC0, 0xC0, // ##      ## 
	0xC0, 0xC0, // ##      ## 
	0xC0, 0xC0, // ##      ## 
	0xC0, 0xC0, // ##      ## 
	0x61, 0x80, //  ##    ##  
	0x3F, 0x00, //   ######   
	0x1E, 0x00, //    ####    
	0x03, 0x80, //       ###  
	0x01, 0xE0, //        ####
	0x00, 0x40, //          # 
	0x00, 0x00, //            

	// @1900 'R' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7F, 0x00, //  #######   
	0x7F, 0x80, //  ########  
	0x61, 0x80, //  ##    ##  
	0x61, 0x80, //  ##    ##  
	0x63, 0x80, //  ##   ###  
	0x7F, 0x00, //  #######   
	0x7E, 0x00, //  ######    
	0x67, 0x00, //  ##  ###   
	0x63, 0x00, //  ##   ##   
	0x61, 0x80, //  ##    ##  
	0x61, 0xC0, //  ##    ### 
	0x60, 0xE0, //  ##     ###
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1938 'S' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1F, 0x00, //    #####   
	0x7F, 0x80, //  ########  
	0x60, 0x80, //  ##     #  
	0x60, 0x00, //  ##        
	0x70, 0x00, //  ###       
	0x3E, 0x00, //   #####    
	0x07, 0x80, //      ####  
	0x01, 0xC0, //        ### 
	0x00, 0xC0, //         ## 
	0x60, 0xC0, //  ##     ## 
	0x7F, 0x80, //  ########  
	0x3F, 0x00, //   ######   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @1976 'T' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0xFF, 0xC0, // ########## 
	0xFF, 0xC0, // ########## 
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2014 'U' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x71, 0xC0, //  ###   ### 
	0x3F, 0x80, //   #######  
	0x1F, 0x00, //    #####   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2052 'V' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0xC0, 0x60, // ##       ##
	0x60, 0xE0, //  ##     ###
	0x60, 0xC0, //  ##     ## 
	0x70, 0xC0, //  ###    ## 
	0x30, 0xC0, //   ##    ## 
	0x39, 0x80, //   ###  ##  
	0x19, 0x80, //    ##  ##  
	0x19, 0x80, //    ##  ##  
	0x0D, 0x00, //     ## #   
	0x0F, 0x00, //     ####   
	0x0F, 0x00, //     ####   
	0x06, 0x00, //      ##    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2090 'W' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0xC0, 0x20, // ##        #
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0x46, 0x40, //  #   ##  # 
	0x4E, 0x40, //  #  ###  # 
	0x4A, 0x40, //  #  # #  # 
	0x4A, 0x40, //  #  # #  # 
	0x6B, 0x40, //  ## # ## # 
	0x6B, 0x40, //  ## # ## # 
	0x71, 0x80, //  ###   ##  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2128 'X' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0xE0, 0x60, // ###      ##
	0x70, 0xC0, //  ###    ## 
	0x31, 0x80, //   ##   ##  
	0x3B, 0x00, //   ### ##   
	0x1E, 0x00, //    ####    
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x1F, 0x00, //    #####   
	0x13, 0x80, //    #  ###  
	0x31, 0x80, //   ##   ##  
	0x61, 0xC0, //  ##    ### 
	0xC0, 0xE0, // ##      ###
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2166 'Y' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0xC0, 0x60, // ##       ##
	0x60, 0xC0, //  ##     ## 
	0x30, 0xC0, //   ##    ## 
	0x39, 0x80, //   ###  ##  
	0x19, 0x00, //    ##  #   
	0x0F, 0x00, //     ####   
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2204 'Z' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7F, 0xE0, //  ##########
	0x7F, 0xE0, //  ##########
	0x00, 0xE0, //         ###
	0x01, 0xC0, //        ### 
	0x03, 0x80, //       ###  
	0x07, 0x00, //      ###   
	0x0E, 0x00, //     ###    
	0x1C, 0x00, //    ###     
	0x38, 0x00, //   ###      
	0x70, 0x00, //  ###       
	0x7F, 0xE0, //  ##########
	0x7F, 0xE0, //  ##########
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2242 '[' (11 pixels wide)
	0x0F, 0xC0, //     ###### 
	0x0F, 0xC0, //     ###### 
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0F, 0xC0, //     ###### 
	0x0F, 0xC0, //     ###### 
	0x00, 0x00, //            

	// @2280 '\' (11 pixels wide)
	0x60, 0x00, //  ##        
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x01, 0x80, //        ##  
	0x00, 0xC0, //         ## 
	0x00, 0x00, //            

	// @2318 ']' (11 pixels wide)
	0x3F, 0x00, //   ######   
	0x3F, 0x00, //   ######   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x3F, 0x00, //   ######   
	0x3F, 0x00, //   ######   
	0x00, 0x00, //            

	// @2356 '^' (11 pixels wide)
	0x00, 0x00, //            
	0x04, 0x00, //      #     
	0x04, 0x00, //      #     
	0x0E, 0x00, //     ###    
	0x0A, 0x00, //     # #    
	0x0A, 0x00, //     # #    
	0x1B, 0x00, //    ## ##   
	0x11, 0x00, //    #   #   
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x20, 0x80, //   #     #  
	0x60, 0xC0, //  ##     ## 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2394 '_' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0xFF, 0xE0, // ###########
	0xFF, 0xE0, // ###########
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2432 '`' (11 pixels wide)
	0x0C, 0x00, //     ##     
	0x06, 0x00, //      ##    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2470 'a' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1F, 0x00, //    #####   
	0x3F, 0x80, //   #######  
	0x21, 0x80, //   #    ##  
	0x01, 0x80, //        ##  
	0x1F, 0x80, //    ######  
	0x31, 0x80, //   ##   ##  
	0x61, 0x80, //  ##    ##  
	0x63, 0x80, //  ##   ###  
	0x7F, 0xE0, //  ##########
	0x3C, 0xE0, //   ####  ###
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2508 'b' (11 pixels wide)
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x67, 0x00, //  ##  ###   
	0x7F, 0x80, //  ########  
	0x71, 0xC0, //  ###   ### 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x71, 0x80, //  ###   ##  
	0x7F, 0x80, //  ########  
	0x6F, 0x00, //  ## ####   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2546 'c' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x0F, 0x80, //     #####  
	0x3F, 0xC0, //   ######## 
	0x30, 0x00, //   ##       
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x38, 0x00, //   ###      
	0x3F, 0xC0, //   ######## 
	0x0F, 0x80, //     #####  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2584 'd' (11 pixels wide)
	0x00, 0xC0, //         ## 
	0x00, 0xC0, //         ## 
	0x00, 0xC0, //         ## 
	0x00, 0xC0, //         ## 
	0x00, 0xC0, //         ## 
	0x1E, 0xC0, //    #### ## 
	0x3F, 0xC0, //   ######## 
	0x31, 0xC0, //   ##   ### 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x71, 0xC0, //  ###   ### 
	0x3F, 0xC0, //   ######## 
	0x1E, 0xC0, //    #### ## 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2622 'e' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x0F, 0x00, //     ####   
	0x3F, 0x80, //   #######  
	0x31, 0xC0, //   ##   ### 
	0x60, 0xC0, //  ##     ## 
	0x7F, 0xC0, //  ######### 
	0x7F, 0xC0, //  ######### 
	0x60, 0x00, //  ##        
	0x70, 0x40, //  ###     # 
	0x3F, 0xC0, //   ######## 
	0x0F, 0x80, //     #####  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2660 'f' (11 pixels wide)
	0x03, 0xE0, //       #####
	0x07, 0xE0, //      ######
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x7F, 0xE0, //  ##########
	0x7F, 0xE0, //  ##########
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2698 'g' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1E, 0xC0, //    #### ## 
	0x3F, 0xC0, //   ######## 
	0x31, 0xC0, //   ##   ### 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x71, 0xC0, //  ###   ### 
	0x3F, 0xC0, //   ######## 
	0x1E, 0xC0, //    #### ## 
	0x00, 0xC0, //         ## 
	0x21, 0xC0, //   #    ### 
	0x3F, 0x80, //   #######  
	0x1F, 0x00, //    #####   

	// @2736 'h' (11 pixels wide)
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x67, 0x80, //  ##  ####  
	0x7F, 0xC0, //  ######### 
	0x78, 0xC0, //  ####   ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2774 'i' (11 pixels wide)
	0x00, 0x00, //            
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7E, 0x00, //  ######    
	0x7E, 0x00, //  ######    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2812 'j' (11 pixels wide)
	0x00, 0x00, //            
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x3F, 0x00, //   ######   
	0x3F, 0x00, //   ######   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x43, 0x00, //  #    ##   
	0x7E, 0x00, //  ######    
	0x3C, 0x00, //   ####     

	// @2850 'k' (11 pixels wide)
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x63, 0x80, //  ##   ###  
	0x67, 0x00, //  ##  ###   
	0x66, 0x00, //  ##  ##    
	0x6C, 0x00, //  ## ##     
	0x7C, 0x00, //  #####     
	0x6C, 0x00, //  ## ##     
	0x6E, 0x00, //  ## ###    
	0x67, 0x00, //  ##  ###   
	0x63, 0x80, //  ##   ###  
	0x61, 0xC0, //  ##    ### 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2888 'l' (11 pixels wide)
	0x3F, 0x00, //   ######   
	0x3F, 0x00, //   ######   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x03, 0x00, //       ##   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2926 'm' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0xD9, 0x80, // ## ##  ##  
	0xFF, 0xC0, // ########## 
	0xEE, 0xC0, // ### ### ## 
	0xCC, 0xC0, // ##  ##  ## 
	0xCC, 0xC0, // ##  ##  ## 
	0xCC, 0xC0, // ##  ##  ## 
	0xCC, 0xC0, // ##  ##  ## 
	0xCC, 0xC0, // ##  ##  ## 
	0xCC, 0xC0, // ##  ##  ## 
	0xCC, 0xC0, // ##  ##  ## 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @2964 'n' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x67, 0x80, //  ##  ####  
	0x7F, 0xC0, //  ######### 
	0x78, 0xC0, //  ####   ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @3002 'o' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1E, 0x00, //    ####    
	0x7F, 0x80, //  ########  
	0x61, 0x80, //  ##    ##  
	0xC0, 0xC0, // ##      ## 
	0xC0, 0xC0, // ##      ## 
	0xC0, 0xC0, // ##      ## 
	0xC0, 0xC0, // ##      ## 
	0x61, 0x80, //  ##    ##  
	0x7F, 0x80, //  ########  
	0x1E, 0x00, //    ####    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @3040 'p' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x6F, 0x00, //  ## ####   
	0x7F, 0x80, //  ########  
	0x71, 0xC0, //  ###   ### 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x71, 0x80, //  ###   ##  
	0x7F, 0x80, //  ########  
	0x6F, 0x00, //  ## ####   
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        
	0x60, 0x00, //  ##        

	// @3078 'q' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1E, 0xC0, //    #### ## 
	0x3F, 0xC0, //   ######## 
	0x31, 0xC0, //   ##   ### 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x71, 0xC0, //  ###   ### 
	0x3F, 0xC0, //   ######## 
	0x1C, 0xC0, //    ###  ## 
	0x00, 0xC0, //         ## 
	0x00, 0xC0, //         ## 
	0x00, 0xC0, //         ## 
	0x00, 0xC0, //         ## 

	// @3116 'r' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x37, 0x80, //   ## ####  
	0x3F, 0x80, //   #######  
	0x38, 0x80, //   ###   #  
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x30, 0x00, //   ##       
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @3154 's' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x1F, 0x80, //    ######  
	0x3F, 0x80, //   #######  
	0x30, 0x00, //   ##       
	0x38, 0x00, //   ###      
	0x1F, 0x00, //    #####   
	0x07, 0x80, //      ####  
	0x00, 0xC0, //         ## 
	0x20, 0xC0, //   #     ## 
	0x3F, 0xC0, //   ######## 
	0x1F, 0x00, //    #####   
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @3192 't' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0xFF, 0xC0, // ########## 
	0xFF, 0xC0, // ########## 
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x18, 0x00, //    ##      
	0x1F, 0xC0, //    ####### 
	0x0F, 0xC0, //     ###### 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @3230 'u' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x60, 0xC0, //  ##     ## 
	0x63, 0xC0, //  ##   #### 
	0x7F, 0xC0, //  ######### 
	0x3C, 0xC0, //   ####  ## 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @3268 'v' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x60, 0xC0, //  ##     ## 
	0x30, 0xC0, //   ##    ## 
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x19, 0x80, //    ##  ##  
	0x19, 0x00, //    ##  #   
	0x0F, 0x00, //     ####   
	0x0F, 0x00, //     ####   
	0x0E, 0x00, //     ###    
	0x06, 0x00, //      ##    
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @3306 'w' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0xC0, 0x20, // ##        #
	0xC6, 0x60, // ##   ##  ##
	0xCE, 0x60, // ##  ###  ##
	0x4A, 0x40, //  #  # #  # 
	0x4A, 0x40, //  #  # #  # 
	0x6B, 0x40, //  ## # ## # 
	0x73, 0xC0, //  ###  #### 
	0x71, 0xC0, //  ###   ### 
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @3344 'x' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x70, 0xC0, //  ###    ## 
	0x31, 0x80, //   ##   ##  
	0x1B, 0x00, //    ## ##   
	0x1F, 0x00, //    #####   
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x1F, 0x00, //    #####   
	0x13, 0x00, //    #  ##   
	0x31, 0x80, //   ##   ##  
	0x61, 0xC0, //  ##    ### 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @3382 'y' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x60, 0xC0, //  ##     ## 
	0x30, 0x80, //   ##    #  
	0x31, 0x80, //   ##   ##  
	0x31, 0x80, //   ##   ##  
	0x1B, 0x00, //    ## ##   
	0x1B, 0x00, //    ## ##   
	0x1E, 0x00, //    ####    
	0x0E, 0x00, //     ###    
	0x0E, 0x00, //     ###    
	0x04, 0x00, //      #     
	0x0C, 0x00, //     ##     
	0x0C, 0x00, //     ##     
	0x38, 0x00, //   ###      
	0x30, 0x00, //   ##       

	// @3420 'z' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x7F, 0xC0, //  ######### 
	0x7F, 0xC0, //  ######### 
	0x01, 0x80, //        ##  
	0x03, 0x00, //       ##   
	0x06, 0x00, //      ##    
	0x0C, 0x00, //     ##     
	0x18, 0x00, //    ##      
	0x30, 0x00, //   ##       
	0x7F, 0xC0, //  ######### 
	0x7F, 0xC0, //  ######### 
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            

	// @3458 '{' (11 pixels wide)
	0x03, 0xC0, //       #### 
	0x07, 0xC0, //      ##### 
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x1C, 0x00, //    ###     
	0x1C, 0x00, //    ###     
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x07, 0xC0, //      ##### 
	0x03, 0xC0, //       #### 
	0x00, 0x00, //            

	// @3496 '|' (11 pixels wide)
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x00, 0x00, //            

	// @3534 '}' (11 pixels wide)
	0x3C, 0x00, //   ####     
	0x3E, 0x00, //   #####    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x03, 0x80, //       ###  
	0x03, 0x80, //       ###  
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x06, 0x00, //      ##    
	0x3E, 0x00, //   #####    
	0x3C, 0x00, //   ####     
	0x00, 0x00, //            

	// @3572 '~' (11 pixels wide)
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x3C, 0x40, //   ####   # 
	0x7F, 0xC0, //  ######### 
	0x47, 0x80, //  #   ####  
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
	0x00, 0x00, //            
};

// Character descriptors for Lucida Console 14pt
// { [Char width in bits], [Char height in bits], [Offset into lucidaConsole_14ptCharBitmaps in bytes] }
const FONT_CHAR_INFO lucidaConsole_14ptDescriptors[] = 
{
	{11, 19, 0}, 		//   
	{11, 19, 38}, 		// ! 
	{11, 19, 76}, 		// " 
	{11, 19, 114}, 		// # 
	{11, 19, 152}, 		// $ 
	{11, 19, 190}, 		// % 
	{11, 19, 228}, 		// & 
	{11, 19, 266}, 		// ' 
	{11, 19, 304}, 		// ( 
	{11, 19, 342}, 		// ) 
	{11, 19, 380}, 		// * 
	{11, 19, 418}, 		// + 
	{11, 19, 456}, 		// , 
	{11, 19, 494}, 		// - 
	{11, 19, 532}, 		// . 
	{11, 19, 570}, 		// / 
	{11, 19, 608}, 		// 0 
	{11, 19, 646}, 		// 1 
	{11, 19, 684}, 		// 2 
	{11, 19, 722}, 		// 3 
	{11, 19, 760}, 		// 4 
	{11, 19, 798}, 		// 5 
	{11, 19, 836}, 		// 6 
	{11, 19, 874}, 		// 7 
	{11, 19, 912}, 		// 8 
	{11, 19, 950}, 		// 9 
	{11, 19, 988}, 		// : 
	{11, 19, 1026}, 		// ; 
	{11, 19, 1064}, 		// < 
	{11, 19, 1102}, 		// = 
	{11, 19, 1140}, 		// > 
	{11, 19, 1178}, 		// ? 
	{11, 19, 1216}, 		// @ 
	{11, 19, 1254}, 		// A 
	{11, 19, 1292}, 		// B 
	{11, 19, 1330}, 		// C 
	{11, 19, 1368}, 		// D 
	{11, 19, 1406}, 		// E 
	{11, 19, 1444}, 		// F 
	{11, 19, 1482}, 		// G 
	{11, 19, 1520}, 		// H 
	{11, 19, 1558}, 		// I 
	{11, 19, 1596}, 		// J 
	{11, 19, 1634}, 		// K 
	{11, 19, 1672}, 		// L 
	{11, 19, 1710}, 		// M 
	{11, 19, 1748}, 		// N 
	{11, 19, 1786}, 		// O 
	{11, 19, 1824}, 		// P 
	{11, 19, 1862}, 		// Q 
	{11, 19, 1900}, 		// R 
	{11, 19, 1938}, 		// S 
	{11, 19, 1976}, 		// T 
	{11, 19, 2014}, 		// U 
	{11, 19, 2052}, 		// V 
	{11, 19, 2090}, 		// W 
	{11, 19, 2128}, 		// X 
	{11, 19, 2166}, 		// Y 
	{11, 19, 2204}, 		// Z 
	{11, 19, 2242}, 		// [ 
	{11, 19, 2280}, 		// Backslash
	{11, 19, 2318}, 		// ] 
	{11, 19, 2356}, 		// ^ 
	{11, 19, 2394}, 		// _ 
	{11, 19, 2432}, 		// ` 
	{11, 19, 2470}, 		// a 
	{11, 19, 2508}, 		// b 
	{11, 19, 2546}, 		// c 
	{11, 19, 2584}, 		// d 
	{11, 19, 2622}, 		// e 
	{11, 19, 2660}, 		// f 
	{11, 19, 2698}, 		// g 
	{11, 19, 2736}, 		// h 
	{11, 19, 2774}, 		// i 
	{11, 19, 2812}, 		// j 
	{11, 19, 2850}, 		// k 
	{11, 19, 2888}, 		// l 
	{11, 19, 2926}, 		// m 
	{11, 19, 2964}, 		// n 
	{11, 19, 3002}, 		// o 
	{11, 19, 3040}, 		// p 
	{11, 19, 3078}, 		// q 
	{11, 19, 3116}, 		// r 
	{11, 19, 3154}, 		// s 
	{11, 19, 3192}, 		// t 
	{11, 19, 3230}, 		// u 
	{11, 19, 3268}, 		// v 
	{11, 19, 3306}, 		// w 
	{11, 19, 3344}, 		// x 
	{11, 19, 3382}, 		// y 
	{11, 19, 3420}, 		// z 
	{11, 19, 3458}, 		// { 
	{11, 19, 3496}, 		// | 
	{11, 19, 3534}, 		// } 
	{11, 19, 3572}, 		// ~ 
};

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wdiscarded-qualifiers"

// Font information for Lucida Console 14pt
FONT_INFO lucidaConsole_14ptFontInfo =
{
	' ', //  Start character
	'~', //  End character
	lucidaConsole_14ptDescriptors, //  Character descriptor array
	lucidaConsole_14ptBitmaps, //  Character bitmap array
};
#pragma GCC diagnostic pop
