// 
//  Font data for Lucida Console 12pt
// 

#include <main.h>

// Character bitmaps for Lucida Console 12pt
const uint8_t lucidaConsole_12ptBitmaps[] =
{
	// @0 ' ' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @32 '!' (11 pixels wide)
	0x00, 0x00, //
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x00, 0x00, //
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @64 '"' (11 pixels wide)
	0x00, 0x00, //
	0x33, 0x00, //   ##  ##
	0x33, 0x00, //   ##  ##
	0x33, 0x00, //   ##  ##
	0x33, 0x00, //   ##  ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @96 '#' (11 pixels wide)
	0x00, 0x00, //
	0x0D, 0x80, //     ## ##
	0x0D, 0x80, //     ## ##
	0x1B, 0x00, //    ## ##
	0x1B, 0x00, //    ## ##
	0x7F, 0xC0, //  #########
	0x1B, 0x00, //    ## ##
	0x36, 0x00, //   ## ##
	0xFF, 0xC0, // ##########
	0x36, 0x00, //   ## ##
	0x36, 0x00, //   ## ##
	0x6C, 0x00, //  ## ##
	0x6C, 0x00, //  ## ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @128 '$' (11 pixels wide)
	0x06, 0x00, //      ##
	0x1F, 0x80, //    ######
	0x3E, 0x00, //   #####
	0x36, 0x00, //   ## ##
	0x36, 0x00, //   ## ##
	0x1E, 0x00, //    ####
	0x0E, 0x00, //     ###
	0x07, 0x00, //      ###
	0x07, 0x80, //      ####
	0x07, 0x80, //      ####
	0x07, 0x80, //      ####
	0x37, 0x80, //   ## ####
	0x3F, 0x00, //   ######
	0x06, 0x00, //      ##
	0x00, 0x00, //
	0x00, 0x00, //

	// @160 '%' (11 pixels wide)
	0x00, 0x00, //
	0x78, 0x60, //  ####    ##
	0xCC, 0xC0, // ##  ##  ##
	0xCD, 0x80, // ##  ## ##
	0xCF, 0x00, // ##  ####
	0x7B, 0x00, //  #### ##
	0x06, 0x00, //      ##
	0x0C, 0x00, //     ##
	0x1B, 0xC0, //    ## ####
	0x1E, 0x60, //    ####  ##
	0x36, 0x60, //   ## ##  ##
	0x66, 0x60, //  ##  ##  ##
	0xC3, 0xC0, // ##    ####
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @192 '&' (11 pixels wide)
	0x00, 0x00, //
	0x1E, 0x00, //    ####
	0x33, 0x00, //   ##  ##
	0x33, 0x00, //   ##  ##
	0x37, 0x00, //   ## ###
	0x1E, 0x00, //    ####
	0x38, 0x00, //   ###
	0x6C, 0x60, //  ## ##   ##
	0xCE, 0x60, // ##  ###  ##
	0xC6, 0xC0, // ##   ## ##
	0xC3, 0xC0, // ##    ####
	0x63, 0x80, //  ##   ###
	0x3F, 0xC0, //   ########
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @224 ''' (11 pixels wide)
	0x00, 0x00, //
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @256 '(' (11 pixels wide)
	0x00, 0x00, //
	0x01, 0xC0, //        ###
	0x07, 0x00, //      ###
	0x0E, 0x00, //     ###
	0x0C, 0x00, //     ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x0C, 0x00, //     ##
	0x0E, 0x00, //     ###
	0x07, 0x00, //      ###
	0x01, 0xC0, //        ###
	0x00, 0x00, //

	// @288 ')' (11 pixels wide)
	0x00, 0x00, //
	0x70, 0x00, //  ###
	0x1C, 0x00, //    ###
	0x0E, 0x00, //     ###
	0x06, 0x00, //      ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x06, 0x00, //      ##
	0x0E, 0x00, //     ###
	0x1C, 0x00, //    ###
	0x70, 0x00, //  ###
	0x00, 0x00, //

	// @320 '*' (11 pixels wide)
	0x00, 0x00, //
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x7F, 0x80, //  ########
	0x3F, 0x00, //   ######
	0x1E, 0x00, //    ####
	0x1E, 0x00, //    ####
	0x1E, 0x00, //    ####
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @352 '+' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0xFF, 0xC0, // ##########
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @384 ',' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x0E, 0x00, //     ###
	0x0E, 0x00, //     ###
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x0C, 0x00, //     ##

	// @416 '-' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x3F, 0x80, //   #######
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @448 '.' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x1C, 0x00, //    ###
	0x1C, 0x00, //    ###
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @480 '/' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0xC0, //         ##
	0x01, 0x80, //        ##
	0x01, 0x80, //        ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x30, 0x00, //   ##
	0x30, 0x00, //   ##
	0x60, 0x00, //  ##
	0x00, 0x00, //

	// @512 '0' (11 pixels wide)
	0x00, 0x00, //
	0x1E, 0x00, //    ####
	0x33, 0x00, //   ##  ##
	0x33, 0x00, //   ##  ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x33, 0x00, //   ##  ##
	0x33, 0x00, //   ##  ##
	0x1E, 0x00, //    ####
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @544 '1' (11 pixels wide)
	0x00, 0x00, //
	0x0C, 0x00, //     ##
	0x7C, 0x00, //  #####
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x7F, 0x80, //  ########
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @576 '2' (11 pixels wide)
	0x00, 0x00, //
	0x7E, 0x00, //  ######
	0x63, 0x00, //  ##   ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x0C, 0x00, //     ##
	0x18, 0x00, //    ##
	0x30, 0x00, //   ##
	0x60, 0x00, //  ##
	0x7F, 0x00, //  #######
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @608 '3' (11 pixels wide)
	0x00, 0x00, //
	0x3E, 0x00, //   #####
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x1E, 0x00, //    ####
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x3E, 0x00, //   #####
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @640 '4' (11 pixels wide)
	0x00, 0x00, //
	0x06, 0x00, //      ##
	0x0E, 0x00, //     ###
	0x1E, 0x00, //    ####
	0x1E, 0x00, //    ####
	0x36, 0x00, //   ## ##
	0x66, 0x00, //  ##  ##
	0x66, 0x00, //  ##  ##
	0xC6, 0x00, // ##   ##
	0xFF, 0x80, // #########
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @672 '5' (11 pixels wide)
	0x00, 0x00, //
	0x3F, 0x00, //   ######
	0x30, 0x00, //   ##
	0x30, 0x00, //   ##
	0x30, 0x00, //   ##
	0x3C, 0x00, //   ####
	0x06, 0x00, //      ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x06, 0x00, //      ##
	0x3C, 0x00, //   ####
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @704 '6' (11 pixels wide)
	0x00, 0x00, //
	0x1F, 0x00, //    #####
	0x30, 0x00, //   ##
	0x30, 0x00, //   ##
	0x60, 0x00, //  ##
	0x7E, 0x00, //  ######
	0x73, 0x00, //  ###  ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x33, 0x00, //   ##  ##
	0x1E, 0x00, //    ####
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @736 '7' (11 pixels wide)
	0x00, 0x00, //
	0x7F, 0x80, //  ########
	0x01, 0x80, //        ##
	0x03, 0x00, //       ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x30, 0x00, //   ##
	0x30, 0x00, //   ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @768 '8' (11 pixels wide)
	0x00, 0x00, //
	0x3F, 0x00, //   ######
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x37, 0x00, //   ## ###
	0x1C, 0x00, //    ###
	0x37, 0x00, //   ## ###
	0x63, 0x00, //  ##   ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x63, 0x00, //  ##   ##
	0x3E, 0x00, //   #####
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @800 '9' (11 pixels wide)
	0x00, 0x00, //
	0x1E, 0x00, //    ####
	0x33, 0x00, //   ##  ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x33, 0x80, //   ##  ###
	0x1F, 0x80, //    ######
	0x01, 0x80, //        ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x3E, 0x00, //   #####
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @832 ':' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x1C, 0x00, //    ###
	0x1C, 0x00, //    ###
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x1C, 0x00, //    ###
	0x1C, 0x00, //    ###
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @864 ';' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x1C, 0x00, //    ###
	0x1C, 0x00, //    ###
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x1C, 0x00, //    ###
	0x1C, 0x00, //    ###
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x18, 0x00, //    ##

	// @896 '<' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0xC0, //         ##
	0x03, 0x80, //       ###
	0x0E, 0x00, //     ###
	0x38, 0x00, //   ###
	0x38, 0x00, //   ###
	0x0E, 0x00, //     ###
	0x03, 0x80, //       ###
	0x00, 0xC0, //         ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @928 '=' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x7F, 0xC0, //  #########
	0x00, 0x00, //
	0x00, 0x00, //
	0x7F, 0xC0, //  #########
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @960 '>' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x60, 0x00, //  ##
	0x38, 0x00, //   ###
	0x0E, 0x00, //     ###
	0x03, 0x80, //       ###
	0x03, 0x80, //       ###
	0x0E, 0x00, //     ###
	0x38, 0x00, //   ###
	0x60, 0x00, //  ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @992 '?' (11 pixels wide)
	0x00, 0x00, //
	0x7F, 0x00, //  #######
	0x63, 0x80, //  ##   ###
	0x61, 0x80, //  ##    ##
	0x01, 0x80, //        ##
	0x03, 0x00, //       ##
	0x06, 0x00, //      ##
	0x0C, 0x00, //     ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x00, 0x00, //
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1024 '@' (11 pixels wide)
	0x00, 0x00, //
	0x1F, 0x00, //    #####
	0x31, 0x80, //   ##   ##
	0x67, 0x80, //  ##  ####
	0xED, 0x80, // ### ## ##
	0xD9, 0x80, // ## ##  ##
	0xD9, 0x80, // ## ##  ##
	0xDB, 0x80, // ## ## ###
	0xDB, 0x80, // ## ## ###
	0xDF, 0x80, // ## ######
	0x6F, 0xE0, //  ## #######
	0x73, 0x00, //  ###  ##
	0x3F, 0x00, //   ######
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1056 'A' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x0C, 0x00, //     ##
	0x1E, 0x00, //    ####
	0x1E, 0x00, //    ####
	0x1B, 0x00, //    ## ##
	0x33, 0x00, //   ##  ##
	0x31, 0x80, //   ##   ##
	0x7F, 0x80, //  ########
	0x60, 0xC0, //  ##     ##
	0x60, 0xC0, //  ##     ##
	0xC0, 0x60, // ##       ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1088 'B' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x7F, 0x00, //  #######
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x63, 0x00, //  ##   ##
	0x7E, 0x00, //  ######
	0x63, 0x00, //  ##   ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x7F, 0x00, //  #######
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1120 'C' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x1F, 0x80, //    ######
	0x71, 0x80, //  ###   ##
	0x60, 0x00, //  ##
	0xC0, 0x00, // ##
	0xC0, 0x00, // ##
	0xC0, 0x00, // ##
	0xC0, 0x00, // ##
	0x60, 0x00, //  ##
	0x70, 0x00, //  ###
	0x1F, 0x80, //    ######
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1152 'D' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x7E, 0x00, //  ######
	0x63, 0x00, //  ##   ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x63, 0x00, //  ##   ##
	0x7E, 0x00, //  ######
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1184 'E' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x7F, 0x80, //  ########
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x7F, 0x00, //  #######
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x7F, 0x80, //  ########
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1216 'F' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x7F, 0x80, //  ########
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x7F, 0x00, //  #######
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1248 'G' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x0F, 0xC0, //     ######
	0x38, 0xC0, //   ###   ##
	0x30, 0x00, //   ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x63, 0xC0, //  ##   ####
	0x60, 0xC0, //  ##     ##
	0x30, 0xC0, //   ##    ##
	0x38, 0xC0, //   ###   ##
	0x0F, 0xC0, //     ######
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1280 'H' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x7F, 0x80, //  ########
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1312 'I' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x7F, 0x80, //  ########
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x7F, 0x80, //  ########
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1344 'J' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x1F, 0x00, //    #####
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x3E, 0x00, //   #####
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1376 'K' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x61, 0x80, //  ##    ##
	0x63, 0x00, //  ##   ##
	0x66, 0x00, //  ##  ##
	0x6C, 0x00, //  ## ##
	0x78, 0x00, //  ####
	0x78, 0x00, //  ####
	0x6C, 0x00, //  ## ##
	0x67, 0x00, //  ##  ###
	0x61, 0x80, //  ##    ##
	0x60, 0xC0, //  ##     ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1408 'L' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x7F, 0x80, //  ########
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1440 'M' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0xE3, 0x80, // ###   ###
	0xE3, 0x80, // ###   ###
	0xF3, 0x80, // ####  ###
	0xF7, 0x80, // #### ####
	0xF7, 0x80, // #### ####
	0xFF, 0x80, // #########
	0xDD, 0x80, // ## ### ##
	0xDD, 0x80, // ## ### ##
	0xC1, 0x80, // ##     ##
	0xC1, 0x80, // ##     ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1472 'N' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x61, 0x80, //  ##    ##
	0x71, 0x80, //  ###   ##
	0x79, 0x80, //  ####  ##
	0x79, 0x80, //  ####  ##
	0x6D, 0x80, //  ## ## ##
	0x6D, 0x80, //  ## ## ##
	0x67, 0x80, //  ##  ####
	0x67, 0x80, //  ##  ####
	0x63, 0x80, //  ##   ###
	0x61, 0x80, //  ##    ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1504 'O' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x1F, 0x00, //    #####
	0x31, 0x80, //   ##   ##
	0x60, 0xC0, //  ##     ##
	0x60, 0xC0, //  ##     ##
	0x60, 0xC0, //  ##     ##
	0x60, 0xC0, //  ##     ##
	0x60, 0xC0, //  ##     ##
	0x60, 0xC0, //  ##     ##
	0x31, 0x80, //   ##   ##
	0x1F, 0x00, //    #####
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1536 'P' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x7F, 0x00, //  #######
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x63, 0x00, //  ##   ##
	0x7E, 0x00, //  ######
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1568 'Q' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x1F, 0x00, //    #####
	0x31, 0x80, //   ##   ##
	0x60, 0xC0, //  ##     ##
	0x60, 0xC0, //  ##     ##
	0x60, 0xC0, //  ##     ##
	0x60, 0xC0, //  ##     ##
	0x60, 0xC0, //  ##     ##
	0x60, 0xC0, //  ##     ##
	0x31, 0x80, //   ##   ##
	0x1F, 0x00, //    #####
	0x03, 0x00, //       ##
	0x01, 0xC0, //        ###
	0x00, 0x00, //

	// @1600 'R' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x7E, 0x00, //  ######
	0x63, 0x00, //  ##   ##
	0x63, 0x00, //  ##   ##
	0x63, 0x00, //  ##   ##
	0x66, 0x00, //  ##  ##
	0x7C, 0x00, //  #####
	0x6C, 0x00, //  ## ##
	0x66, 0x00, //  ##  ##
	0x63, 0x00, //  ##   ##
	0x61, 0x80, //  ##    ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1632 'S' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x3F, 0x80, //   #######
	0x61, 0x80, //  ##    ##
	0x60, 0x00, //  ##
	0x70, 0x00, //  ###
	0x1C, 0x00, //    ###
	0x07, 0x00, //      ###
	0x01, 0x80, //        ##
	0x01, 0x80, //        ##
	0x63, 0x80, //  ##   ###
	0x7E, 0x00, //  ######
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1664 'T' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0xFF, 0xC0, // ##########
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1696 'U' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x33, 0x00, //   ##  ##
	0x3E, 0x00, //   #####
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1728 'V' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0xC0, 0x60, // ##       ##
	0x60, 0xC0, //  ##     ##
	0x60, 0xC0, //  ##     ##
	0x31, 0x80, //   ##   ##
	0x31, 0x80, //   ##   ##
	0x33, 0x00, //   ##  ##
	0x1B, 0x00, //    ## ##
	0x1B, 0x00, //    ## ##
	0x0E, 0x00, //     ###
	0x0E, 0x00, //     ###
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1760 'W' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0xC0, 0x60, // ##       ##
	0xC0, 0x60, // ##       ##
	0x6C, 0xC0, //  ## ##  ##
	0x6E, 0xC0, //  ## ### ##
	0x6E, 0xC0, //  ## ### ##
	0x7E, 0xC0, //  ###### ##
	0x7B, 0xC0, //  #### ####
	0x3B, 0x80, //   ### ###
	0x3B, 0x80, //   ### ###
	0x31, 0x80, //   ##   ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1792 'X' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0xC0, 0x60, // ##       ##
	0x60, 0xC0, //  ##     ##
	0x31, 0x80, //   ##   ##
	0x1B, 0x00, //    ## ##
	0x0E, 0x00, //     ###
	0x0E, 0x00, //     ###
	0x1B, 0x00, //    ## ##
	0x31, 0x80, //   ##   ##
	0x60, 0xC0, //  ##     ##
	0xC0, 0x60, // ##       ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1824 'Y' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0xC0, 0x60, // ##       ##
	0x60, 0xC0, //  ##     ##
	0x31, 0x80, //   ##   ##
	0x33, 0x00, //   ##  ##
	0x1E, 0x00, //    ####
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1856 'Z' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x7F, 0xC0, //  #########
	0x00, 0xC0, //         ##
	0x01, 0x80, //        ##
	0x03, 0x00, //       ##
	0x06, 0x00, //      ##
	0x0C, 0x00, //     ##
	0x18, 0x00, //    ##
	0x30, 0x00, //   ##
	0x60, 0x00, //  ##
	0x7F, 0xC0, //  #########
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @1888 '[' (11 pixels wide)
	0x00, 0x00, //
	0x1F, 0x80, //    ######
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x1F, 0x80, //    ######
	0x00, 0x00, //

	// @1920 '\' (11 pixels wide)
	0x00, 0x00, //
	0x60, 0x00, //  ##
	0x30, 0x00, //   ##
	0x30, 0x00, //   ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x01, 0x80, //        ##
	0x01, 0x80, //        ##
	0x00, 0xC0, //         ##
	0x00, 0x00, //

	// @1952 ']' (11 pixels wide)
	0x00, 0x00, //
	0x7E, 0x00, //  ######
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x7E, 0x00, //  ######
	0x00, 0x00, //

	// @1984 '^' (11 pixels wide)
	0x00, 0x00, //
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x0E, 0x00, //     ###
	0x0F, 0x00, //     ####
	0x1F, 0x00, //    #####
	0x1B, 0x00, //    ## ##
	0x19, 0x80, //    ##  ##
	0x31, 0x80, //   ##   ##
	0x31, 0x80, //   ##   ##
	0x60, 0xC0, //  ##     ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2016 '_' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0xFF, 0xE0, // ###########
	0x00, 0x00, //
	0x00, 0x00, //

	// @2048 '`' (11 pixels wide)
	0x0C, 0x00, //     ##
	0x06, 0x00, //      ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2080 'a' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x3E, 0x00, //   #####
	0x03, 0x00, //       ##
	0x03, 0x00, //       ##
	0x1F, 0x00, //    #####
	0x33, 0x00, //   ##  ##
	0x63, 0x00, //  ##   ##
	0x67, 0x00, //  ##  ###
	0x3F, 0x80, //   #######
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2112 'b' (11 pixels wide)
	0x00, 0x00, //
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x7F, 0x00, //  #######
	0x73, 0x00, //  ###  ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x73, 0x00, //  ###  ##
	0x7E, 0x00, //  ######
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2144 'c' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x1F, 0x80, //    ######
	0x30, 0x00, //   ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x30, 0x00, //   ##
	0x1F, 0x80, //    ######
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2176 'd' (11 pixels wide)
	0x00, 0x00, //
	0x01, 0x80, //        ##
	0x01, 0x80, //        ##
	0x01, 0x80, //        ##
	0x01, 0x80, //        ##
	0x1F, 0x80, //    ######
	0x33, 0x80, //   ##  ###
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x33, 0x80, //   ##  ###
	0x3F, 0x80, //   #######
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2208 'e' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x1F, 0x00, //    #####
	0x31, 0x80, //   ##   ##
	0x61, 0x80, //  ##    ##
	0x7F, 0x80, //  ########
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x30, 0x00, //   ##
	0x1F, 0x80, //    ######
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2240 'f' (11 pixels wide)
	0x00, 0x00, //
	0x07, 0xC0, //      #####
	0x1C, 0x00, //    ###
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x7F, 0xC0, //  #########
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2272 'g' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x1F, 0x80, //    ######
	0x33, 0x80, //   ##  ###
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x33, 0x80, //   ##  ###
	0x3F, 0x80, //   #######
	0x01, 0x80, //        ##
	0x03, 0x00, //       ##
	0x3E, 0x00, //   #####

	// @2304 'h' (11 pixels wide)
	0x00, 0x00, //
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x6F, 0x00, //  ## ####
	0x79, 0x80, //  ####  ##
	0x71, 0x80, //  ###   ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2336 'i' (11 pixels wide)
	0x00, 0x00, //
	0x1C, 0x00, //    ###
	0x1C, 0x00, //    ###
	0x00, 0x00, //
	0x00, 0x00, //
	0x7C, 0x00, //  #####
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2368 'j' (11 pixels wide)
	0x00, 0x00, //
	0x0E, 0x00, //     ###
	0x0E, 0x00, //     ###
	0x00, 0x00, //
	0x00, 0x00, //
	0x3E, 0x00, //   #####
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x7C, 0x00, //  #####

	// @2400 'k' (11 pixels wide)
	0x00, 0x00, //
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x61, 0x80, //  ##    ##
	0x67, 0x00, //  ##  ###
	0x6C, 0x00, //  ## ##
	0x78, 0x00, //  ####
	0x78, 0x00, //  ####
	0x6E, 0x00, //  ## ###
	0x63, 0x00, //  ##   ##
	0x61, 0x80, //  ##    ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2432 'l' (11 pixels wide)
	0x00, 0x00, //
	0x3E, 0x00, //   #####
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2464 'm' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0xFB, 0x80, // ##### ###
	0xEE, 0xC0, // ### ### ##
	0xCC, 0xC0, // ##  ##  ##
	0xCC, 0xC0, // ##  ##  ##
	0xCC, 0xC0, // ##  ##  ##
	0xCC, 0xC0, // ##  ##  ##
	0xCC, 0xC0, // ##  ##  ##
	0xCC, 0xC0, // ##  ##  ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2496 'n' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x6F, 0x00, //  ## ####
	0x79, 0x80, //  ####  ##
	0x71, 0x80, //  ###   ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2528 'o' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x1E, 0x00, //    ####
	0x33, 0x00, //   ##  ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x33, 0x00, //   ##  ##
	0x1E, 0x00, //    ####
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2560 'p' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x7F, 0x00, //  #######
	0x73, 0x00, //  ###  ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x73, 0x00, //  ###  ##
	0x7E, 0x00, //  ######
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##

	// @2592 'q' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x1F, 0x80, //    ######
	0x33, 0x80, //   ##  ###
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x33, 0x80, //   ##  ###
	0x3F, 0x80, //   #######
	0x01, 0x80, //        ##
	0x01, 0x80, //        ##
	0x01, 0x80, //        ##

	// @2624 'r' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x37, 0x80, //   ## ####
	0x3D, 0x80, //   #### ##
	0x39, 0x80, //   ###  ##
	0x30, 0x00, //   ##
	0x30, 0x00, //   ##
	0x30, 0x00, //   ##
	0x30, 0x00, //   ##
	0x30, 0x00, //   ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2656 's' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x3F, 0x00, //   ######
	0x60, 0x00, //  ##
	0x60, 0x00, //  ##
	0x38, 0x00, //   ###
	0x0E, 0x00, //     ###
	0x03, 0x00, //       ##
	0x63, 0x00, //  ##   ##
	0x7E, 0x00, //  ######
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2688 't' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x7F, 0x80, //  ########
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x18, 0x00, //    ##
	0x0F, 0x80, //     #####
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2720 'u' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x63, 0x00, //  ##   ##
	0x63, 0x00, //  ##   ##
	0x63, 0x00, //  ##   ##
	0x63, 0x00, //  ##   ##
	0x63, 0x00, //  ##   ##
	0x63, 0x00, //  ##   ##
	0x67, 0x00, //  ##  ###
	0x3F, 0x00, //   ######
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2752 'v' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0xC0, 0xC0, // ##      ##
	0x61, 0x80, //  ##    ##
	0x61, 0x80, //  ##    ##
	0x63, 0x00, //  ##   ##
	0x33, 0x00, //   ##  ##
	0x36, 0x00, //   ## ##
	0x1E, 0x00, //    ####
	0x1C, 0x00, //    ###
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2784 'w' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0xC0, 0x60, // ##       ##
	0xCC, 0x60, // ##  ##   ##
	0x6E, 0xC0, //  ## ### ##
	0x6E, 0xC0, //  ## ### ##
	0x7B, 0xC0, //  #### ####
	0x7B, 0xC0, //  #### ####
	0x3B, 0x80, //   ### ###
	0x31, 0x80, //   ##   ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2816 'x' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x60, 0xC0, //  ##     ##
	0x31, 0x80, //   ##   ##
	0x1B, 0x00, //    ## ##
	0x0E, 0x00, //     ###
	0x0E, 0x00, //     ###
	0x1B, 0x00, //    ## ##
	0x31, 0x80, //   ##   ##
	0x60, 0xC0, //  ##     ##
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2848 'y' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0xC0, 0x60, // ##       ##
	0x60, 0xC0, //  ##     ##
	0x60, 0xC0, //  ##     ##
	0x31, 0x80, //   ##   ##
	0x3B, 0x00, //   ### ##
	0x1B, 0x00, //    ## ##
	0x0E, 0x00, //     ###
	0x0E, 0x00, //     ###
	0x0C, 0x00, //     ##
	0x18, 0x00, //    ##
	0xF0, 0x00, // ####

	// @2880 'z' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x7F, 0xC0, //  #########
	0x01, 0x80, //        ##
	0x03, 0x00, //       ##
	0x06, 0x00, //      ##
	0x0C, 0x00, //     ##
	0x18, 0x00, //    ##
	0x30, 0x00, //   ##
	0x7F, 0xC0, //  #########
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //

	// @2912 '{' (11 pixels wide)
	0x00, 0x00, //
	0x07, 0x80, //      ####
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x38, 0x00, //   ###
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x07, 0x80, //      ####
	0x00, 0x00, //

	// @2944 '|' (11 pixels wide)
	0x00, 0x00, //
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x0C, 0x00, //     ##
	0x00, 0x00, //

	// @2976 '}' (11 pixels wide)
	0x00, 0x00, //
	0x3C, 0x00, //   ####
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x03, 0x80, //       ###
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x06, 0x00, //      ##
	0x3C, 0x00, //   ####
	0x00, 0x00, //

	// @3008 '~' (11 pixels wide)
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x78, 0x60, //  ####    ##
	0xCE, 0x60, // ##  ###  ##
	0xC3, 0xC0, // ##    ####
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
	0x00, 0x00, //
};

// Character descriptors for Lucida Console 12pt
// { [Char width in bits], [Char height in bits], [Offset into lucidaConsole_12ptCharBitmaps in bytes] }
const FONT_CHAR_INFO lucidaConsole_12ptDescriptors[] = 
{
	{11, 16, 0}, 		//
	{11, 16, 32}, 		// !
	{11, 16, 64}, 		// "
	{11, 16, 96}, 		// #
	{11, 16, 128}, 		// $
	{11, 16, 160}, 		// %
	{11, 16, 192}, 		// &
	{11, 16, 224}, 		// '
	{11, 16, 256}, 		// (
	{11, 16, 288}, 		// )
	{11, 16, 320}, 		// *
	{11, 16, 352}, 		// +
	{11, 16, 384}, 		// ,
	{11, 16, 416}, 		// -
	{11, 16, 448}, 		// .
	{11, 16, 480}, 		// /
	{11, 16, 512}, 		// 0
	{11, 16, 544}, 		// 1
	{11, 16, 576}, 		// 2
	{11, 16, 608}, 		// 3
	{11, 16, 640}, 		// 4
	{11, 16, 672}, 		// 5
	{11, 16, 704}, 		// 6
	{11, 16, 736}, 		// 7
	{11, 16, 768}, 		// 8
	{11, 16, 800}, 		// 9
	{11, 16, 832}, 		// :
	{11, 16, 864}, 		// ;
	{11, 16, 896}, 		// <
	{11, 16, 928}, 		// =
	{11, 16, 960}, 		// >
	{11, 16, 992}, 		// ?
	{11, 16, 1024}, 		// @
	{11, 16, 1056}, 		// A
	{11, 16, 1088}, 		// B
	{11, 16, 1120}, 		// C
	{11, 16, 1152}, 		// D
	{11, 16, 1184}, 		// E
	{11, 16, 1216}, 		// F
	{11, 16, 1248}, 		// G
	{11, 16, 1280}, 		// H
	{11, 16, 1312}, 		// I
	{11, 16, 1344}, 		// J
	{11, 16, 1376}, 		// K
	{11, 16, 1408}, 		// L
	{11, 16, 1440}, 		// M
	{11, 16, 1472}, 		// N
	{11, 16, 1504}, 		// O
	{11, 16, 1536}, 		// P
	{11, 16, 1568}, 		// Q
	{11, 16, 1600}, 		// R
	{11, 16, 1632}, 		// S
	{11, 16, 1664}, 		// T
	{11, 16, 1696}, 		// U
	{11, 16, 1728}, 		// V
	{11, 16, 1760}, 		// W
	{11, 16, 1792}, 		// X
	{11, 16, 1824}, 		// Y
	{11, 16, 1856}, 		// Z
	{11, 16, 1888}, 		// [
	{11, 16, 1920}, 		// Backslash
	{11, 16, 1952}, 		// ]
	{11, 16, 1984}, 		// ^
	{11, 16, 2016}, 		// _
	{11, 16, 2048}, 		// `
	{11, 16, 2080}, 		// a
	{11, 16, 2112}, 		// b
	{11, 16, 2144}, 		// c
	{11, 16, 2176}, 		// d
	{11, 16, 2208}, 		// e
	{11, 16, 2240}, 		// f
	{11, 16, 2272}, 		// g
	{11, 16, 2304}, 		// h
	{11, 16, 2336}, 		// i
	{11, 16, 2368}, 		// j
	{11, 16, 2400}, 		// k
	{11, 16, 2432}, 		// l
	{11, 16, 2464}, 		// m
	{11, 16, 2496}, 		// n
	{11, 16, 2528}, 		// o
	{11, 16, 2560}, 		// p
	{11, 16, 2592}, 		// q
	{11, 16, 2624}, 		// r
	{11, 16, 2656}, 		// s
	{11, 16, 2688}, 		// t
	{11, 16, 2720}, 		// u
	{11, 16, 2752}, 		// v
	{11, 16, 2784}, 		// w
	{11, 16, 2816}, 		// x
	{11, 16, 2848}, 		// y
	{11, 16, 2880}, 		// z
	{11, 16, 2912}, 		// {
	{11, 16, 2944}, 		// |
	{11, 16, 2976}, 		// }
	{11, 16, 3008}, 		// ~
};


#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wdiscarded-qualifiers"
// Font information for Lucida Console 12pt
FONT_INFO lucidaConsole_12ptFontInfo =
{
	' ', //  Start character
	'~', //  End character
	lucidaConsole_12ptDescriptors, //  Character descriptor array
	lucidaConsole_12ptBitmaps, //  Character bitmap array
};
#pragma GCC diagnostic pop

