#!/usr/bin/python
#
# Send LinuxCNC data via UDP broadcast message
# Jan 2022, harry4516@yahoo.de
#

import hal, time, socket

DESTPORT = 13579
message = ""

# create an UDP socket
sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
# allow to send broadcast messages
sock.setsockopt(socket.SOL_SOCKET, socket.SO_BROADCAST, 1)

# calculate broadcast IP for local network
# get own IP address
sock.connect(("1.2.3.4", 80))	# dummy connect, any IP will work
myip = sock.getsockname()[0]
# and convert into broadcast IP
myip_arr = myip.split(".")
bc_ip = myip_arr[0] + "." + myip_arr[1] + "." + myip_arr[2] + ".255"

def makeString(element):
    global message
    global h
    message = message + str(h[element]) + ";"

# create module and PINs for LinuxCNC
h = hal.component("ext_UDP")
h.newpin("in_x_abs", hal.HAL_FLOAT, hal.HAL_IN)
h.newpin("in_y_abs", hal.HAL_FLOAT, hal.HAL_IN)
h.newpin("in_z_abs", hal.HAL_FLOAT, hal.HAL_IN)
h.newpin("in_a_abs", hal.HAL_FLOAT, hal.HAL_IN)
h.newpin("in_x_g54", hal.HAL_FLOAT, hal.HAL_IN)
h.newpin("in_y_g54", hal.HAL_FLOAT, hal.HAL_IN)
h.newpin("in_z_g54", hal.HAL_FLOAT, hal.HAL_IN)
h.newpin("in_a_g54", hal.HAL_FLOAT, hal.HAL_IN)
h.newpin("in_xhomeswitch", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in_yhomeswitch", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in_zhomeswitch", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in_probe", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in_limit", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in_mist", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in_paused", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in_ismanual", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in_ismdi", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in_isauto", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in_isrunning", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in_machineison", hal.HAL_BIT, hal.HAL_IN)
h.newpin("in_currvelocity", hal.HAL_FLOAT, hal.HAL_IN)
h.ready()

try:
	while 1:
        # send LinuxCNC data every 250ms
		time.sleep(0.25)
		# Build the message ";" is the string separator
		message = "LINUXCNC;"
		makeString('in_x_abs')
		makeString('in_y_abs')
		makeString('in_z_abs')
		makeString('in_a_abs')
		makeString('in_x_g54')
		makeString('in_y_g54')
		makeString('in_z_g54')
		makeString('in_a_g54')
		makeString('in_xhomeswitch')
		makeString('in_yhomeswitch')
		makeString('in_zhomeswitch')
		makeString('in_probe')
		makeString('in_limit')
		makeString('in_mist')
		makeString('in_paused')
		makeString('in_ismanual')
		makeString('in_ismdi')
		makeString('in_isauto')
		makeString('in_isrunning')
		makeString('in_machineison')
		makeString('in_currvelocity')
		
		# make message shorter
		message = message.replace("False","F")
		message = message.replace("True","T")

		# send via UDP
		sock.sendto(message.encode(), (bc_ip, DESTPORT))

except KeyboardInterrupt:
    raise SystemExit

