/*
 * Display für CNC Handgerät
 * =========================
 * 
 * Kurt's CNC Projects, harry4516@yahoo.de
 * 
 * ESP8266MOD D1-Mini
 * 
 * Arduino Einstellungen:
 * Boardverwalter URL: http://arduino.esp8266.com/stable/package_esp8266com_index.json
 * Board: NodeMCU 1.0 (ESP-12E Module)
 */

#include "ESP8266WiFi.h"
#include <WiFiUdp.h>
#include "ampel.h"

#define D5  14
#define D6  12
#define D7  13
#define D8  15

#define YL  D5
#define GN  D6
#define RD  D7
#define ON  1
#define OFF 0

// ===== Netzwerkeinstellungen ======
char* ssid     = "xxxxxxx";
char* password = "xxxxxxx";
WiFiUDP Udp;
unsigned int localUdpPort = 13579;
char incomingPacket[256];
// ==================================

void setup() 
{
  Serial.begin(115200);
  Serial.println("CNC Remote Display"); 
  Serial.print("Connecting to ");

  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) 
  {
      delay(500);
      Serial.print(".");
  }

  Serial.println("WiFi connected");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());

  Udp.begin(localUdpPort);

  pinMode(RD, OUTPUT);
  pinMode(YL, OUTPUT);
  pinMode(GN, OUTPUT);

  // Blinke nach erfolgreichem Start
  for(int i=0; i<5; i++)
  {
    digitalWrite(RD,ON);
    digitalWrite(YL,ON);
    digitalWrite(GN,ON);
    delay(200);
    digitalWrite(RD,OFF);
    digitalWrite(YL,OFF);
    digitalWrite(GN,OFF);
    delay(200);
  }
}

void switchLED(int col, int onoff)
{
    digitalWrite(col,onoff);
    digitalWrite(D6,1);
    digitalWrite(D7,1);
}

int act_spray = 0, act_play = 0, act_pause = 0, act_onoff = 0, act_mode = 0;
int act_xref = 0, act_yref = 0, act_zref = 0, act_probe = 0, act_limit = 0;
float speed = 0;

void loop()
{
  int packetSize = Udp.parsePacket();
  if (packetSize)
  {
    int len = Udp.read(incomingPacket, 255);
    incomingPacket[len]=0;
    Serial.print("RXed len: ");
    Serial.print(len);
    Serial.print(": ");
    Serial.print(Udp.remoteIP());
    Serial.print(": ");
    Serial.println(incomingPacket);

    Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
    Udp.write("AMPEL");
    Udp.endPacket();
    
    rxfunc(incomingPacket, len);
    
    if(rxelem[EL_KSM][0]    == 'T') act_spray = 1; else act_spray = 0;
    if(rxelem[EL_PAUSE][0]  == 'T') act_pause = 1; else act_pause = 0;
    if(rxelem[EL_RUNNING][0]== 'T') act_play = 1; else act_play = 0;
    if(rxelem[EL_ONOFF][0]  == 'T') act_onoff = 1; else act_onoff = 0;
    if(rxelem[EL_AUTO][0]   == 'T') act_mode = 2;
    if(rxelem[EL_MDI][0]    == 'T') act_mode = 1;
    if(rxelem[EL_MANUELL][0]== 'T') act_mode = 0;
    if(rxelem[EL_PROBE][0]    == 'T') act_probe = 1; else act_probe = 0;
    if(rxelem[EL_LIMIT][0]    == 'T') act_limit = 1; else act_limit = 0;
    if(rxelem[EL_XREF][0]    == 'T') act_xref = 1; else act_xref = 0;
    if(rxelem[EL_YREF][0]    == 'T') act_yref = 1; else act_yref = 0;
    if(rxelem[EL_ZREF][0]    == 'T') act_zref = 1; else act_zref = 0;

    speed = atof(rxelem[EL_SPEED]) * 60;
  }

  static int old_spray = -1;  
  static int old_play = -1;  
  static int old_pause = -1;  
  static int old_onoff = -1;  
  static int old_mode = -1;  
  static int old_xref = -1;
  static int old_yref = -1;
  static int old_zref = -1;
  static int old_probe = -1;
  static int old_limit = -1;

  if(act_onoff == 0)
  {
    // Maschine aus, alle Lampen aus
    digitalWrite(RD,OFF);
    digitalWrite(YL,OFF);
    digitalWrite(GN,OFF);
  }
  else
  {
    // Maschine EIN
    if(act_mode == 2)
    {
      // Automode
      if(act_play) 
      {
        digitalWrite(RD,ON);
        digitalWrite(YL,OFF);
        digitalWrite(GN,OFF);
      }
      else 
      {
        digitalWrite(YL,ON);
        digitalWrite(RD,OFF);
        digitalWrite(GN,OFF);
      }
    }
    else
    {
      // Manual or MDI
      if(speed < 0.1)
      {
        digitalWrite(GN,ON);
        digitalWrite(RD,OFF);
        digitalWrite(YL,OFF);
      }
      else
      {
        digitalWrite(GN,OFF);
        digitalWrite(RD,OFF);
        digitalWrite(YL,ON);
      }
    }
  }
  

  // Maschine on/off
  if(act_onoff != old_onoff)
  {
    old_onoff = act_onoff;
  }

  // Op Mode
  if(act_mode != old_mode)
  {
    old_mode = act_mode;
  }

  // Auto Mode State
  if(act_play != old_play || act_pause != old_pause)
  {
    old_play = act_play;
    old_pause = act_pause;
  }

  // KSM
  if(act_spray != old_spray)
  {
    old_spray = act_spray;
  }

  // Referenzschalter
  if(act_xref != old_xref)
  {
    old_xref = act_xref;
  }
  if(act_yref != old_yref)
  {
    old_yref = act_yref;
  }
  if(act_zref != old_zref)
  {
    old_zref = act_zref;
  }

  // Probe und Limit Schalter
  if(act_probe != old_probe)
  {
    old_probe = act_probe;
  }
  if(act_limit != old_limit)
  {
    old_limit = act_limit;
  }
}
