#include "ampel.h"

char *elemname[50] = {
        "LINUXCNC",
        "X",
        "Y",
        "Z",
        "A",
        "G54",
        "G54",
        "G54",
        "G54",
        "X RefSW",
        "Y RefSW",
        "Z RefSW",
        "Probe",
        "Limit",
        "KSM",
        "Pause",
        "Manuell",
        "MDI",
        "AUTO",
        "RUNNING",
        "ON/OFF",
        "Speed",
        ""
};

char rxstr[RXSTRINGLEN];
char rxelem[RXELEMANZ][RXELEMLEN];
int elements;

// Zerlege empfangenes Paket

int rxfunc(char *pdata, int len)
{
    memset(rxstr,0,sizeof(rxstr));
    if(len>(RXSTRINGLEN-1)) len=RXSTRINGLEN-1;
    memcpy(rxstr,pdata,len);

    // split the string
    elements = 0;

    char *hp = strtok(rxstr,";");
    strncpy(rxelem[elements++],hp,RXELEMLEN-1);
    while(1)
    {
        hp = strtok(NULL,";");
        if(!hp) break;
        strncpy(rxelem[elements++],hp,RXELEMLEN-1);
    }

    // Formatiere Koordinaten-Werte
    for(int i=1; i<=8; i++)
    {
      char minus = ' ';
      if(rxelem[i][0] == '-') minus = '-';

      double f = atof(rxelem[i]);

      //f = (double)random(400000) / 1000.0 - 200.000;
      
      f = fabs(f);
      if(f > 9999) f = 9999;

      sprintf(rxelem[i],"%c%8.3f",minus,f);
      //Serial.println(i);
      //Serial.println(rxelem[i]);
    }

    /*for(int i=0; i<elements; i++)
    {
      Serial.print(i);
      Serial.print(": ");
      Serial.println(rxelem[i]);
    }*/

    return elements;
}
